#include "mbed.h"
//I2S Demo to display values from I2S microphone
//
//Only works on mbed LPC1768 - I2S is not an mbed API!
//Microphone used is SPH0645LM4H
//see https://www.adafruit.com/product/3421

#include "I2S.h"
//uses patched mbed I2S library from 
//https://os.mbed.com/users/p07gbar/code/I2S/
//Needed a typo patch - clock was swapped p30/p15 in pin function setup code
//"if (_clk == p15)" changed to "if (_clk != p15)" in I2S.cpp line 494
BusOut mylevel(LED4,LED3,LED2,LED1);
//4 built in mbed LEDs display audio level

#define sample_freq 32000.0

//Uses I2S hardware for input
I2S i2srx(I2S_RECEIVE, p17, p16, p15);
//p17(PWM value sent as serial data bit) <-> Dout
//p16(WS) <-> LRC left/right channel clock
//p15(bit clock) <-> BCLK 

volatile int i=0;

void i2s_isr() //interrupt routine to read microphone
{
    i = i2srx.read();//read value using I2S input
    mylevel = (i>>7)& 0xF; //Display Audio Level on 4 LEDs
}
int main()
{
    i2srx.stereomono(I2S_MONO);//mono not stereo mode
    i2srx.masterslave(I2S_MASTER);//master drives clocks
    i2srx.frequency(sample_freq);//set sample freq
    i2srx.set_interrupt_fifo_level(1);//interrupt on one sample
    i2srx.attach(&i2s_isr);//set I2S ISR
    i2srx.start();//start I2S and interrupts
    while(1) {
        printf("%X\n\r",(i>>16)&(0x0000FFFF));
        wait(0.5);
    }
}
