#include "mbed.h"
#include "I2S.h"
Ticker sampletick;
DigitalOut myled(LED1);
//Plays Audio Clip using Array in Flash
//using I2S input Class D audio amp
//setup const array in flash with audio values
//from free wav file conversion tool at
//http://ccgi.cjseymour.plus.com/wavtocode/wavtocode.htm
//see https://os.mbed.com/users/4180_1/notebook/using-flash-to-play-audio-clips/
//tested on MAX98357A
#include "cylonbyc.h"
#define sample_freq 11025.0

I2S i2s(I2S_TRANSMIT, p5, p6, p7);
//p5(PWM value sent as serial data bit) <-> Din
//p6(WS) <-> LRC left/right channel clock
//p7(bit clock) <-> BCLK

int i = 0;
int bufflen = 1;
int buffer[1];
void isr()
{
    buffer[0] = sound_data[i]>>1;//scale down volume a bit on amp
    i2s.write(buffer, bufflen);//Send next PWM value to amp
    i++;
    if (i>= NUM_ELEMENTS) {
        i = 0;
        sampletick.detach();
        i2s.stop();
        myled = 0;
    }
}

int main()
{
    i2s.stereomono(I2S_MONO);
    i2s.masterslave(I2S_MASTER);
    i2s.frequency(sample_freq);
    while(1) {
        i2s.start();
        myled = 1;
        sampletick.attach(&isr, 1.0/sample_freq);//turn on timer interrupt
        wait(10);
    }
}
