//Executive Decision Maker for Mbed Application Board
#include "mbed.h"
#include "Speaker.h"
#include "PinDetect.h" 
#include "C12832_lcd.h"
#include "Arial_9.h" //font for LCD
#include <math.h> //needed for rand()

DigitalOut myLed1(LED1); //Builtin LEDs
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);
DigitalOut myLed4(LED4);

PinDetect pb1(p14); //Debounce pushbutton and use interrupts

Speaker mySpeaker(p26); //PWM speaker to play notes

Timer t; //use a hardware timer

PwmOut r (p23); //RGB LED pins
PwmOut g (p24);
PwmOut b (p25);

C12832_LCD lcd; //On board LCD display

volatile int pbStatus = 0; //pb hit flag

void pb1_hit_callback (void) //pb interrupt routine - a callback after debounce
{
    pbStatus = 1;
}
void funcD( int i) //display a binary number on mbed's 4 LEDs
{
    myLed1 = i &0x01;
    myLed2 = (i>>1) & 0x01;
    myLed3 = (i>>2) & 0x01;
    myLed4 = (i>>3) & 0x01;
}
int main()
{
    unsigned int number=0;
    //setup debounced pushbutton using interrupts
    pb1.mode(PullDown);
    wait(.01);
    pb1.attach_asserted(&pb1_hit_callback);
    pb1.setSampleFrequency();
    //setup LCD prompt
    lcd.cls();
    lcd.set_font((unsigned char*) Arial_9);
    lcd.printf("   Ask a Question, \n\r   then push Joystick");
    //RGB LED init
    b = 1.0; //blue 1.0=off 
    //use a timer to generate seed for rand (different number to start each time)
    t.start(); //start timer
    while(pbStatus == 0) {}; //timer counts until pb hit
    srand(t.read_ms()); //read ms from timer
    while(1) {
        if(pbStatus == 1) { //pb hit?
            pbStatus = 0; //reset pb hit flag
            lcd.cls();
            lcd.locate(38,10);
            //loop though several random numbers on LEDs and make beeps on Speaker
            for(int i=0; i<24; ++i) {
                number = (rand() % 16);
                mySpeaker.PlayNote(200.0 * (number + 1), 0.1, 1.0);
                funcD(number);
            }
            // Update RGB led:  Red, Yellow, or Green based on number
            // Update LCD: No, Maybe, or Yes
            b = 1.0;
            if (number < 5) {
                r = 0.8;
                g = 1.0;
                lcd.printf("  NO");
            } else {
                r = 0.8;
                g = 0.8;
                if (number <=10) lcd.printf(" MAYBE");
                if (number > 10) {
                    r = 1.0;
                    lcd.printf(" YES");
                }
            }
        }
        wait(.05);
    }
}
