#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "C12832_lcd.h"

C12832_LCD lcd; //Graphics LCD
EthernetInterface eth;
NTPClient ntp;

int main()
{
    eth.init(); //Use DHCP
    wait(2);
    lcd.cls();
    lcd.printf("Getting IP Address\r\n");
    if(eth.connect(60000)!=0) {
        lcd.printf("DHCP error - No IP");
        wait(10);
    } else {
        lcd.printf("IP is %s\n", eth.getIPAddress());
        wait(2);
    }
    lcd.cls();
    lcd.printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0) {
        lcd.printf("Set time successfully\r\n");
        while(1) {
            lcd.cls();
            lcd.locate(0,0);
            time_t ctTime;
            ctTime = time(NULL);
            lcd.printf("%s\r\n", ctime(&ctTime));
            lcd.printf("Current Time (UTC)");
            wait(1);
        }
    } else {
        lcd.printf("NTP Error\r\n");
    }

    eth.disconnect();

    while(1) {
    }
}
