#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "MMA7660.h"
#include "LM75B.h"

// accelerometer
MMA7660 acc(p28, p27);

// temperature sensor
LM75B tmp(p28,p27);

DigitalOut l1(LED1);
 
int main() {
    char json_str[100];
    
    if (acc.testConnection())
        l1 = 1;
 
    EthernetInterface eth;
    eth.init(); //Use DHCP
    wait(2);
    eth.connect(60000);
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    // See the output on http://sockets.mbed.org/app-board/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/app-board/wo");
    ws.connect();
 
    while (1) {
        // create json string with acc/tmp data
        sprintf(json_str, "{\"id\":\"app_board_eth_EW2013\",\"ax\":%d,\"ay\":%d,\"az\":%d, \"tmp\":%d}", (int)(acc.x()*360), (int)(acc.y()*360), (int)(acc.z()*360), (int)tmp.read());
        
        // send str
        ws.send(json_str);
        
        wait(0.1);
    }
}