#include "mbed.h"
// Shiftbrite Sequencer Demo Program
//
//Bits for Shiftbrite latch and enable pins
DigitalOut latch(p15);
DigitalOut enable(p16);
//DigitalOut myled(LED1);

// SPI connections for LED chain
SPI spi(p11, p12, p13);

//Serial PC(USBTX, USBRX);

Timer time_counter;

// number of LEDS in chain
#define num_LEDS 35

// number of color values to sequence through
#define Sequence_Length 17

// number of steps in fade effect
#define Fade_Steps 64


// Each LED'S RGB color values for each step in sequence is stored in an array
int LED_Color [Sequence_Length][num_LEDS][3] = {0};

// delay times in seconds for each RGB color value in sequence
// can be different for each sequence step
float Sequence_Delay[Sequence_Length];
int Sequence_Effect[Sequence_Length] = {0};


// Write (Shift out) 10-bit RGB values to a single LED
void Write_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    red=red;
    green=green;
    blue=blue;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
}
// Sends Initial Current limits to all LEDs in array
// used to correct for different RGB brightness levels in LEDs
void Write_Init_Command(int red_level, int green_level, int blue_level) {
    unsigned int Init_Command = 0x40000000;
    int i=0;
    Init_Command = 0x40000000|(blue_level<<20)|(red_level<<10)|green_level;
    for (i=0; i<num_LEDS; i++) {
        spi.write(Init_Command>>16&0xFFFF);
        spi.write(Init_Command&0xFFFF);
    }
    wait(.000015);
    latch=1;
    wait(.000015);
    latch=0;
}

// Sets all LEDs in a sequence step to a default background color
void Set_Background_Color(int Seq_Step, int red, int green, int blue) {
    int i=0;
    for (i=0; i<num_LEDS; i++) {
        LED_Color[Seq_Step][i][0] = red;
        LED_Color[Seq_Step][i][1] = green;
        LED_Color[Seq_Step][i][2] = blue;
    }
}

// Set a single LED in a Sequence Step to a color
// Last LED in chain is LED #0
//
// LED address in 5x7 array
// 35 in chain serpantine style
// 34 33 32 31 30 29 28
// 27 26 25 24 23 22 21
// 20 19 18 17 16 15 14
// 13 12 11 10 09 08 07
// 06 05 04 03 02 01 00
void Set_LED_Color(int Seq_Step, int LED_num, int red, int green, int blue) {
    LED_Color[Seq_Step][LED_num][0] = red;
    LED_Color[Seq_Step][LED_num][1] = green;
    LED_Color[Seq_Step][LED_num][2] = blue;
}

int main() {
    int i=0;
    int j=0;
    int k=0;
    int red, green, blue;
    bool odd=false;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    int flicker = 0;
    // Set currents using Allegro A6281's command mode
    Write_Init_Command(120, 100, 100);
    // Do once during initialization
    // OK at power on, but a reset could set it to an invalid mode
    //
    // See page 7 in A6281 datasheet
    // This feature can be used to adjust for different LED
    // brightness levels - values suggested from Macetech doc

// Clear out initial sequence values
    for (i=0; i<Sequence_Length; i++) {
        for (j=0; j<num_LEDS; j++) {
            for (k=0; k<4; k++) {
                LED_Color[i][j][k]=0;
            }
        }
        Sequence_Delay[i]=0;
        Sequence_Effect[i]=0;
    }
// Color data values for LEDs to sequence through
// Sequence step 0
    Set_Background_Color(0, 1023, 0, 0); //LEDs RED
    Sequence_Delay[0] = 1;
    Sequence_Effect[0] = 0;
// Sequence step 1
    LED_Color[1][0][0] = 0;
    Set_Background_Color(1, 0, 1023, 0); //LEDs GREEN   
    Sequence_Delay[1] = 2;
    Sequence_Effect[1] = 1; //Fade from RED to GREEN Effect
// Sequence step 2
    Set_Background_Color(2, 0, 0, 1023); //LEDs BLUE
    Sequence_Delay[2] = 2;
    Sequence_Effect[2] = 1; //Fade from GREEN to BLUE Effect
// Sequence step 3
    Set_Background_Color(3, 0, 0, 1023);
    Sequence_Delay[3] = 1; //Stay at this value for 1 seconds
    Sequence_Effect[3] = 0;
// Sequence step 4
    Set_Background_Color(4,1023,200,0); //LEDs all  ORANGE
    Sequence_Delay[4] = 5;
    Sequence_Effect[4] = 2; //Flicker or Twinkle Effect
// Sequence step 5
    Set_Background_Color(5,1023,1023,0); //LEDs all  YELLOW
    Sequence_Delay[5] = 5;
    Sequence_Effect[5] = 3; //Flashing Marquee Sign Effect
// Sequence step 6
    LED_Color[6][0][0] = 1023; //LED 0 RED
    LED_Color[6][0][1] = 0;
    LED_Color[6][0][2] = 0;
    LED_Color[6][1][0] = 1023;
    LED_Color[6][1][1] = 1023;
    LED_Color[6][1][2] = 1023; //LED 1 WHITE
    LED_Color[6][2][0] = 0;
    LED_Color[6][2][1] = 0;
    LED_Color[6][2][2] = 1023; //LED 1 BLUE
    Sequence_Delay[6] = 5;
    Sequence_Effect[6] = 4; //Shift Colors
// Sequence step 7
    Set_Background_Color(7,1023,1023,1023); //LEDs all WHITE
    Sequence_Delay[7] = 1;
    Sequence_Effect[7] = 0;
//Sequence step 8
    Set_Background_Color(8,0,0,0); //LEDs all  Black
    Sequence_Delay[8] = 2;
    Sequence_Effect[8]= 1;  //Fade to Black
//Sequence step 9
    Set_Background_Color(9,0,0,0); //LEDs all  Black
    Sequence_Delay[9] = 1.5;
    Sequence_Effect[9]= 0;
//Sequence step 10
    Sequence_Delay[10] = 6;
    Sequence_Effect[10]= 5; //Random Bright Colors
//Sequence step 11
    Set_Background_Color(11,100,100,100); //LEDs all dim WHITE
    Set_LED_Color(11,34,0,0,1023); //char M
    Set_LED_Color(11,33,0,0,1023);
    Set_LED_Color(11,32,0,0,1023);
    Set_LED_Color(11,31,0,0,1023);
    Set_LED_Color(11,30,0,0,1023);
    Set_LED_Color(11,29,0,0,1023);
    Set_LED_Color(11,28,0,0,1023);
    Set_LED_Color(11,22,0,0,1023);
    Set_LED_Color(11,16,0,0,1023);
    Set_LED_Color(11,17,0,0,1023);
    Set_LED_Color(11,8,0,0,1023);
    Set_LED_Color(11,0,0,0,1023);
    Set_LED_Color(11,1,0,0,1023);
    Set_LED_Color(11,2,0,0,1023);
    Set_LED_Color(11,3,0,0,1023);
    Set_LED_Color(11,4,0,0,1023);
    Set_LED_Color(11,5,0,0,1023);
    Set_LED_Color(11,6,0,0,1023);
    Sequence_Effect[11] = 0;
    Sequence_Delay[11] = 3;
//Sequence step 12
    Set_Background_Color(12,100,100,100); //LEDs all dim WHITE
    Set_LED_Color(12,34,0,0,1023); // char b
    Set_LED_Color(12,33,0,0,1023);
    Set_LED_Color(12,32,0,0,1023);
    Set_LED_Color(12,31,0,0,1023);
    Set_LED_Color(12,30,0,0,1023);
    Set_LED_Color(12,29,0,0,1023);
    Set_LED_Color(12,28,0,0,1023);
    Set_LED_Color(12,27,0,0,1023);
    Set_LED_Color(12,24,0,0,1023);
    Set_LED_Color(12,20,0,0,1023);
    Set_LED_Color(12,17,0,0,1023);
    Set_LED_Color(12,12,0,0,1023);
    Set_LED_Color(12,11,0,0,1023);
    Sequence_Effect[12] = 0;
    Sequence_Delay[12] = 3;
    //Sequence step 13
    Set_Background_Color(13,100,100,100); //LEDs all dim WHITE
    Set_LED_Color(13,34,0,0,1023); //char E
    Set_LED_Color(13,33,0,0,1023);
    Set_LED_Color(13,32,0,0,1023);
    Set_LED_Color(13,31,0,0,1023);
    Set_LED_Color(13,30,0,0,1023);
    Set_LED_Color(13,29,0,0,1023);
    Set_LED_Color(13,28,0,0,1023);
    Set_LED_Color(13,27,0,0,1023);
    Set_LED_Color(13,24,0,0,1023);
    Set_LED_Color(13,21,0,0,1023);
    Set_LED_Color(13,20,0,0,1023);
    Set_LED_Color(13,17,0,0,1023);
    Set_LED_Color(13,14,0,0,1023);
    Set_LED_Color(13,13,0,0,1023);
    Set_LED_Color(13,7,0,0,1023);
    Set_LED_Color(13,6,0,0,1023);
    Set_LED_Color(13,0,0,0,1023);
    Sequence_Effect[13] = 0;
    Sequence_Delay[13] = 3;
    //Sequence step 14
    Set_Background_Color(14,100,100,100); //LEDs all dim WHITE
    Set_LED_Color(14,5,0,0,1023); //char d
    Set_LED_Color(14,4,0,0,1023);
    Set_LED_Color(14,3,0,0,1023);
    Set_LED_Color(14,6,0,0,1023);
    Set_LED_Color(14,2,0,0,1023);
    Set_LED_Color(14,1,0,0,1023);
    Set_LED_Color(14,0,0,0,1023);
    Set_LED_Color(14,13,0,0,1023);
    Set_LED_Color(14,10,0,0,1023);
    Set_LED_Color(14,20,0,0,1023);
    Set_LED_Color(14,17,0,0,1023);
    Set_LED_Color(14,26,0,0,1023);
    Set_LED_Color(14,25,0,0,1023);
    Sequence_Effect[14] = 0;
    Sequence_Delay[14] = 3;
    //Sequence step 15
    Set_Background_Color(15,0,0,0); //LEDs all  Black
    Sequence_Delay[15] = 2;
    Sequence_Effect[15]= 1;  //Fade to Black
    //Sequence step 16
    Set_Background_Color(16,0,0,0); //LEDs all  Black
    Sequence_Delay[16] = 2;
    Sequence_Effect[16]= 0;  //Black
// add more steps or LEDs if needed and change #defines

    wait(1);
    // Repeat Sequence Forever
    while (1) {
        Write_Init_Command(120, 100, 100);
        //Step through the Sequence Values
        for (j = 0; j < Sequence_Length; j++) {
 //           myled= !myled;
            switch (Sequence_Effect[j]) {
                case 0: {
                    // Step through each LED in chain at each sequence step
                    for (i = 0; i < num_LEDS; i++) {
                        //Writes 32-bits of RGB color data to LED using SPI hardware
                        Write_LED( LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                        // Uncomment to get status info on serial port
                        //              printf("i= %d, j= %d\n\r",i,j);
                        //              printf("   %d  %d  %d\n\r",LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                    }
                    //Load in new values just shifted out to LED chain by setting latch high
                    wait(.000015);
                    latch=1;
                    wait(.000015);
                    latch=0;
                    //Delay for this step in the sequence
                    wait(Sequence_Delay[j]);
                    break;
                }
                case 1: {
                    //Lighing Effect: Fade into new color from previous color (note: can't fade first sequence step!)
                    for (k = 0; k<=Fade_Steps; k++) {
                        // Step through each LED in chain at each fade sequence step
                        for (i = 0; i < num_LEDS; i++) {
                            red = LED_Color[j-1][i][0] + k*(LED_Color[j][i][0]-LED_Color[j-1][i][0])/Fade_Steps;
                            green = LED_Color[j-1][i][1] + k*(LED_Color[j][i][1]-LED_Color[j-1][i][1])/Fade_Steps;
                            blue = LED_Color[j-1][i][2] + k*(LED_Color[j][i][2]-LED_Color[j-1][i][2])/Fade_Steps;
                            //Writes 32-bits of RGB color data to LED using SPI hardware
                            Write_LED(red, green, blue);
                            // Uncomment to get status info on serial port
                            //              printf("i= %d, j= %d\n\r",i,j);
                            //              printf("   %d  %d  %d\n\r",LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                        }
                        //Load in new values just shifted out to LED chain by setting latch high
                        wait(.000015);
                        latch=1;
                        wait(.000015);
                        latch=0;
                        //Delay for this step in the fade sequence
                        wait(Sequence_Delay[j]/Fade_Steps);
                    }
                    break;
                }
                case 2: {
                    //Lighting Effect: Flicker or Twinkle somewhat like a flame
                    time_counter.reset();
                    time_counter.start();
                    while (time_counter.read()<Sequence_Delay[j]) {
                        for (i = 0; i < num_LEDS; i++) {
                            flicker = rand();
                            if (flicker>0x40000000)
                                //Writes 32-bits of RGB color data to LED using SPI hardware
                                Write_LED( LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                            // Uncomment to get status info on serial port
                            //              printf("i= %d, j= %d\n\r",i,j);
                            //              printf("   %d  %d  %d\n\r",LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                            else
                                Write_LED( LED_Color[j][i][0]/2, LED_Color[j][i][1]/2, LED_Color[j][i][2]/2);
                        }
                        //Load in new values just shifted out to LED chain by setting latch high
                        wait(.000015);
                        latch=1;
                        wait(.000015);
                        latch=0;
                        wait(.05);
                    }
                    time_counter.stop();
                    break;
                }
                case 3: {
                    //Lighting Effect: Flashing Broadway Marquee Sign Style
                    time_counter.reset();
                    time_counter.start();
                    while (time_counter.read()<Sequence_Delay[j]) {
                        for (i = 0; i < num_LEDS; i++) {
                            if (((i+odd)&0x01)==0)
                                //Writes 32-bits of RGB color data to LED using SPI hardware
                                Write_LED( LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                            // Uncomment to get status info on serial port
                            //              printf("i= %d, j= %d\n\r",i,j);
                            //              printf("   %d  %d  %d\n\r",LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                            else
                                Write_LED( LED_Color[j][i][0]/4, LED_Color[j][i][1]/4, LED_Color[j][i][2]/4);
                        }
                        //Load in new values just shifted out to LED chain by setting latch high
                        wait(.000015);
                        latch=1;
                        wait(.000015);
                        latch=0;
                        wait(.15);
                        odd = !odd;
                    }
                    time_counter.stop();
                    break;
                }
                case 4: {
                    //Lighting Effect: Circular Shift of Colors
                    time_counter.reset();
                    time_counter.start();
                    k=0;
                    while (time_counter.read()<Sequence_Delay[j]) {
                        k = (k+1)%num_LEDS;
                        for (i = 0; i < num_LEDS; i++) {

                            //Writes 32-bits of RGB color data to LED using SPI hardware
                            Write_LED( LED_Color[j][(i+k)%num_LEDS][0], LED_Color[j][(i+k)%num_LEDS][1], LED_Color[j][(i+k)%num_LEDS][2]);
                            // Uncomment to get status info on serial port
                            //              printf("i= %d, j= %d\n\r",i,j);
                            //              printf("   %d  %d  %d\n\r",LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                        }
                        //Load in new values just shifted out to LED chain by setting latch high
                        wait(.000015);
                        latch=1;
                        wait(.000015);
                        latch=0;
                        wait(.10);
                    }
                    time_counter.stop();
                    break;
                    case 5: {
                        //Random Bright Colors
                        time_counter.reset();
                        time_counter.start();
                        k=0;
                        while (time_counter.read()<Sequence_Delay[j]) {
                            k = (k+1)%num_LEDS;
                            for (i = 0; i < num_LEDS; i++) {

                                //Writes 32-bits of RGB color data to LED using SPI hardware
                                Write_LED( (rand()&0x00F000)>>6,(rand()&0x00F000)>>6,(rand()&0x00F000)>>6);
                                // Uncomment to get status info on serial port
                                //              printf("i= %d, j= %d\n\r",i,j);
                                //              printf("   %d  %d  %d\n\r",LED_Color[j][i][0], LED_Color[j][i][1], LED_Color[j][i][2]);
                            }
                            //Load in new values just shifted out to LED chain by setting latch high
                            wait(.000015);
                            latch=1;
                            wait(.000015);
                            latch=0;
                            wait(.08);
                        }
                        time_counter.stop();
                        break;
                    }
                }
            }
        }
    }
}