#include "mbed.h"
 
// Program to use the  mbed as a serial bridge
//
Serial pc(USBTX, USBRX); // tx, rx
Serial dev(D1, D0); // tx, rx
 
void send() {
    while (pc.readable()) {
        dev.putc(pc.getc());
    }
}
 
void recv() {
    pc.putc(dev.getc());
}
 
int main() {
    char c;
    
    // PC serial     
    pc.baud(9600);
    pc.attach(send, Serial::RxIrq);
    
    // Device serial 
    dev.baud(9600);   // LS20031 57600 
 
    //dev.printf("$PMTK314,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,5*2D\r\n");
    //dev.printf("$PMTK103*30\r\n");
    wait(0.1);
    dev.printf("AT+RST\r\n");
    while(1) {
    
        c = dev.getc();
        pc.putc(c);
 
    }
 
}