#include "mbed.h"
// NOTE: Need "target.components_add": ["SD"] in json project file!
// This adds the filesystem driver below for SD cards in a project
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
Serial pc(USBTX,USBRX); //change for your mbed serial port
SDBlockDevice sd(p5, p6, p7, p8);
FATFileSystem fs("SD");
char filereadchar=0;

int main()
{
    sd.init();
    fs.mount(&sd);
// open and write a message in a new file
    FILE* fw = fopen("/SD/hi.txt", "w");
    if(fw == NULL) {
        error("Could not open new file for write\n\r");
    }
    printf("Writing to SD file: hello SD Card!\n\r");
    fprintf(fw, "hello SD card!\n\r");
    fclose(fw);
    printf("\nFile closed for write\n\n\r");
// open and read back file characters to serial for test
    FILE* fr = fopen("/SD/hi.txt", "r");
    if(fr == NULL) {
        error("Could not open new file for read\n\r");
    }
    printf("Reading back from new file: ");
    while(fscanf(fr,"%c",&filereadchar) == 1) {
        printf("\%c",filereadchar);
    }
    fclose(fr);
    sd.deinit();
    fs.unmount();
    printf("\nSD demo complete\n\r");
}