#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p9, p10);  // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
//RF link demo using low-cost Sparkfun RF transmitter and receiver modules
//LEDs indicate link activity
//Characters typed in PC terminal windows will echo back using RF link
int main() {
    char temp=0;
    device.baud(2400);
    while (1) {
    
        //RF Transmit Code
        if (pc.readable()==0) {
            myled1 = 1;
            //Send 10101010 pattern when idle to keep receiver in sync and locked to transmitter
            //When receiver loses the sync lock (Around 30MS with no data change seen) it starts sending out noise
            device.putc(0xAA);
            myled1 = 0;
        } else
            //Send out the real data whenever a key is typed 
            device.putc(pc.getc());
            
        //RF Receive Code
        if (device.readable()) {
            myled2 = 1;
            temp=device.getc();
            //Ignore Sync pattern and do not pass on to PC
            if (temp!=0xAA) pc.putc(temp);
            myled2 = 0;
        }
    }
}
