
#include "mbed.h"

PwmOut led(LED1); // led 1 indicates dim value
DigitalOut led2(LED2); // led 2 indicates delay time for interrupts

// pin for ZeroCross tail input
// An external 1K pullup required
InterruptIn zerocross(p27);

// pin for PowerSSRtail output
DigitalOut SSR(p21);

//use timer interrupts to control dimming
Timeout SSRtriggerOn;

// dimmer value 0.0=off and 1.0=full on
volatile float dim;

// AC power line frequency
const float powerlinefrequency=60.000;

// this interrupt routine is activated after a time delay set by dim value
void triggerOn()
{
    SSR = 1;
    led2=0;
}

// this interrupt routine is activated by every AC line zero crossing
// it is needed to synchronize the SCR turnon time delay to the AC line
void dimmer()
{
    // turn off SSR at zero crossing
    SSR = 0;
    // compute time delay using dim value and set timer interrupt
    // triggers SSR after a small post zero crossing time delay
    SSRtriggerOn.attach(&triggerOn,(1.001-dim)/(2*powerlinefrequency));
    led2=1;
}

int main()
{
    //set up interrupt routine to detect AC line zero crossings
    zerocross.mode(PullNone);
    wait(.2);
    zerocross.rise(&dimmer);
    // main program only sets dimmer level (dim)
    // interrupt routines dim the light
    while(1) {
        //increase brightness
        for(dim = 0.0; dim <= 1.0; dim += 0.025) {
            led = dim;
            wait(0.05);
        }
        //decrease brightness
        for(dim = 1.0; dim >= 0.0; dim -= 0.025) {
            led = dim;
            wait(0.05);
        }
    }
}

