#include "mbed.h"
//Pi Console Cable function
// connect gnd on Pi header to mbed
// connect mbed p9 to Pi RX pin
// connect mbed p10 to Pi TX pin
// Enable serial console on Pi (needed one time only)
// Run terminal application on PC at 115200 baud
// See https://developer.mbed.org/users/4180_1/notebook/using-mbed-for-a-pi-console-cable/#
RawSerial  pc(USBTX, USBRX);
RawSerial  dev(p9, p10);
DigitalOut led1(LED1);
DigitalOut led4(LED4);
 
void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}
 
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}
 
int main()
{
    pc.baud(115200);
    dev.baud(115200);
 
    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
 
    while(1) {
        sleep();
    }
}