#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NokiaLCD.h"
//CNN Tech News RSS Feed - get web page with XML
// displays titles on LCD  from XML "<title>....title text...</title>"
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}

int main() {
    char *tstartXML = "<title>"; //RSS XML start title
    char *tendXML ="</title>"; //RSS XML end title
    char *tsptr;
    char *teptr;
    int i=0,j=0;
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("net setup");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("net error");
        return -1;
    }
    lcd.locate(0,2);
    lcd.printf("net ok");
    wait(1);
    lcd.cls();
    HTTPStream stream;
    char BigBuf[2048 + 1] = {0};
    stream.readNext((byte*)BigBuf, 2048); //Point to buffer for the first read
    //CNN Tech News RSS Feed - get web page with XML
    HTTPResult r = http.get("HTTP://rss.cnn.com/rss/cnn_tech.rss", &stream, request_callback);
    while (!completed) {
        Net::poll(); // Polls the Networking stack
        if (stream.readable()) { // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                teptr = strstr(tsptr,tendXML); // find <\title> in string - NULL if not
                if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"
                if ((tsptr!=NULL)&&(teptr!=NULL)) {
                    i=0;
                    // loop to display lines on LCD
                    for (j=0; (j)<(strlen(tsptr)-strlen(teptr)); j=j+16) {
  //                      lcd.cls(); // clear screen before writing a new line
                        lcd.locate(0,(2+(j/16)));
                        // loop to output a line on the LCD
                        for (i=0; ((i<16)&&(tsptr[i+j] != '<')); i++) {
                            lcd.putc(tsptr[i+j]);
                        }
                    }
                    wait(4);
                    lcd.cls(); //clear LCD between news items
                    lcd.locate(0,2);
                }
            } while (tsptr!=NULL); // No more "<title>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 2048); //Buffer has been read, now we can put more data in it
        }
    }
    lcd.cls();
    if (result == HTTP_OK) {
        lcd.cls();
        lcd.locate(0,1);
        lcd.printf(" Read complete");
    } else {
        lcd.printf(" Error %d\", result");
        return -1;
    }
}
