#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"
//CNN Tech News RSS Feed - get web page with XML
// displays titles on LCD  from XML "<title>....title text...</title>"
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d0-d3
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}

int main() {
    char *tstartXML = "<title>"; //RSS XML start title
    char *tendXML ="</title>"; //RSS XML end title
    char *tsptr;
    char *teptr;
    int i=0,j=0;
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
    lcd.cls();
    lcd.printf("net setup");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("\n\r net error");
        return -1;
    }
    lcd.printf("\n\r net ok");
    HTTPStream stream;
    char BigBuf[2048 + 1] = {0};
    stream.readNext((byte*)BigBuf, 2048); //Point to buffer for the first read
    //CNN Tech News RSS Feed - get web page with XML
    HTTPResult r = http.get("HTTP://rss.cnn.com/rss/cnn_tech.rss", &stream, request_callback);
    while (!completed) {
        Net::poll(); // Polls the Networking stack
        if (stream.readable()) { // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                teptr = strstr(tsptr,tendXML); // find <\title> in string - NULL if not
                if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"
                if ((tsptr!=NULL)&&(teptr!=NULL)) {
                    i=0;
                    // loop to scroll characters slowly across LCD
                    for (j=0; (j+15)<(strlen(tsptr)-strlen(teptr)); j++) {
                        lcd.cls(); // clear screen before writing a new line
                        // loop to output a line on the LCD
                        for (i=0; ((i<16)&&(tsptr[i+j-1] != '<')); i++) {
                            lcd.putc(tsptr[i+j]);
                        }
                        if (j==0) wait(1.2); //add first line delays for scroll timing
                        wait(.2); //delay for charcter scroll timing
                    }
                    wait(.4);
                    lcd.cls(); //clear LCD between news items
                    wait(.2);
                }
            } while (tsptr!=NULL); // No more "<title>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 2048); //Buffer has been read, now we can put more data in it
        }
    }
    lcd.cls();
    if (result == HTTP_OK) {
        lcd.cls();
        lcd.printf(" Read complete\n\r");
    } else {
        lcd. printf(" Error %d\n", result);
        return -1;
    }
}
