#include "mbed.h"
//Demo program for the Parallax Laser Range Finder
//
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Serial lrf(p9,p10);

int main() {
    int mm_range=0;
    char lrfchar=0;

//Print prompt
    pc.printf("\f\nLaser Range Finder demo program\n\r");
//Delay for lrf power on startup
    wait(2.5);
    lrf.baud(115200);

// lrf autobaud setup
    do {
        lrf.putc('U');
        pc.putc('.');
        wait(.2);
        if (lrf.readable()) lrfchar = lrf.getc();
    } while (lrfchar != ':');
    pc.printf("\n\r");
    // clear out any extra characters - just in case
    while (lrf.readable()) {
        lrfchar = lrf.getc();
    }


// Loop taking range readings forever
    while (1) {
        myled=1;
        lrf.putc('B'); //Take Binary range reading
        // read in the four bytes for the range in mm (MSB first)
        mm_range=0;
        mm_range=lrf.getc();
        mm_range=(mm_range<<8)|lrf.getc();
        mm_range=(mm_range<<8)|lrf.getc();
        mm_range=(mm_range<<8)|lrf.getc();
        myled=0;
        //eat CR & ":" command prompt
        do {
            lrfchar=lrf.getc();
        } while (lrfchar != ':');
        //Display readings on PC Virtual Com port via USB cable
        pc.printf("Range is %d mm\n\r",mm_range);
    }
}
