#include "mbed.h"
//LED welding lighting effect
PwmOut myled(LED1);
//Use PWM output to enable LED dimming

//Use Cs random number generator rand(), but scaled and
//converted to a float 0.0 to 1.0 for PWM output
inline float random_number()
{
    return (rand()/(float(RAND_MAX)));
}

int main()
{
    float x = 0.0;
    while(1) {
        //get a new random number for PWM
        x = random_number();
        //add some exponential brightness scaling
        //for more of a fast flash effect
        myled = x*x*x;
        //fast update rate for welding flashes
        wait(0.02);
        //add a random pause between welds
        if (random_number()>0.9925) {
            myled=0.0;
            wait(4.0*random_number());
        }
    }
}