#include "mbed.h"
//LED Railroad Crossing Lighting Effect
PwmOut myled(LED1);
PwmOut myled2(LED4);
//Use a PWM output to enable dimming
//1.0 is full on, 0.0 off, 0.5 50% on

//function to simulate incandescent bulb warm up 
//and cool down cycles
void incandescent_bulb(PwmOut led, float on_time = 0.1, 
float warm_time = 0.2)
{
    //LED warm up effect using PWM
    for(int i=0; i<10; i++) {
        led = i/10.0;
        wait(warm_time/10.0);
    }
    //LED at full brightness level
    led = 1.0;
    wait(on_time);
    //LED cool down effect using PWM
    for(int i=9; i>0; i--) {
        led = i/10.0;
        wait(warm_time/10.0);
    }
    //LED off
    led = 0.0;
}

int main()
{
    while(1) {
        incandescent_bulb(myled);
        incandescent_bulb(myled2);
    }
}
