#include "mbed.h"
//LED effects demo using RTOS, threads, and built-in LEDs
// info at https://os.mbed.com/users/4180_1/notebook/led-lighting-effects-for-modelers/
// NOTE: waits will take too long unless firmware is upgraded on LPC1768 board
// See https://os.mbed.com/handbook/Firmware-LPC1768-LPC11U24
Thread thread1, thread2, thread3;
DigitalOut myled(LED1);
PwmOut myled2(LED2);
PwmOut myled3(LED3);
PwmOut myled4(LED4);

inline float random_number()
{
    return (rand()/(float(RAND_MAX)));
}

void beacon()
{
    while(1) {
        //LED warm up effect using PWM
        for(int i=0; i<50; i++) {
            myled2 = i/50.0;
            wait(0.02);
        }
        //LED at full brightness level
        myled2 = 1.0;
        wait(0.25);
        //LED cool down effect using PWM
        for(int i=49; i>0; i--) {
            myled2 = i/50.0;
            wait(0.02);
        }
        //LED off
        myled2 = 0.0;
        wait(1.5);
    }
}
void welding()
{
    float x = 0.0;

    while(1) {
        //get a new random number for PWM
        x = random_number();
        //add some exponential brightness scaling
        //for more of a fast flash effect
        myled3 = x*x*x;
        //fast update rate for welding flashes
        wait(0.02);
        //add a random pause between welds
        if (random_number()>0.9925) {
            myled3 = 0.0;
            wait(4.0*random_number());
        }
    }
}

void lighthouse()
{
    float y=0.0;

    while(1) {
        for(double x=0.0; x <= 3.14159; x = x + 0.0314159) {
            y = sin(x); //nice periodic function 0..1..0
            myled4 = y*y*y;//exponential effect - needs a sharp peak
            wait(.025);
        }
        myled4 = 0.0;
        //most lighthouses have a 5 second delay - so add another 2.5
        wait(2.5);
    }
}

int main()
{
    myled2.period(1.0/10000.0);
    myled3.period(1.0/10000.0);
    myled4.period(1.0/10000.0);
    sleep_manager_lock_deep_sleep(); //lock out all 10ms deep sleep delays
    thread1.start(callback(beacon));
    thread2.start(callback(welding));
    thread3.start(callback(lighthouse));
    //main runs standard LED blink demo
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
