#include "mbed.h"
#include "rtos.h"
DigitalOut myled(LED1);
PwmOut myled2(LED2);
PwmOut myled3(LED3);
PwmOut myled4(LED4);

inline float random_number(){
    return (rand()/(float(RAND_MAX)));
}
 
void beacon(void const *args){
    while(1) {
        //LED warm up effect using PWM
        for(int i=0; i<50; i++) {
            myled2 = i/50.0;
            Thread::wait(1000.0*0.02);
        }
        //LED at full brightness level
        myled2 = 1.0;
        Thread::wait(1000.0*0.25);
        //LED cool down effect using PWM
        for(int i=49; i>0; i--) {
            myled2 = i/50.0;
            Thread::wait(1000.0*0.02);
        }
        //LED off
        myled2 = 0.0;
        Thread::wait(1000.0*1.5);
    }
}
void welding(void const *args) {
    float x = 0.0;
    while(1) {
        //get a new random number for PWM
        x = random_number();
        //add some exponential brightness scaling
        //for more of a fast flash effect
        myled3 = x*x*x;
        //fast update rate for welding flashes
        Thread::wait(1000.0*0.02);
        //add a random pause between welds
        if (random_number()>0.9925) {
            myled3 = 0.0;
            Thread::wait(1000.0*4.0*random_number());
        }
    }
}

void lighthouse(void const *args){
    float y=0.0;
    while(1) {
        for(double x=0.0; x <= 3.14159; x = x + 0.0314159) {
            y = sin(x); //nice periodic function 0..1..0
            myled4 = y*y*y;//exponential effect - needs a sharp peak
            Thread::wait(1000.0*.025);
        }
        myled4 = 0.0;
        //most lighthouses have a 5 second delay - so add another 2.5
        Thread::wait(1000.0*2.5);
    }
}

int main() {
    Thread thread2(beacon);
    Thread thread3(welding);
    Thread thread4(lighthouse);
    //main runs standard LED blink demo
    while(1) {
        myled = 1;
        Thread::wait(1000.0*0.2);
        myled = 0;
        Thread::wait(1000.0*0.2);
    }
}
