#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "NokiaLCD.h"
// Internet of Things clock example: LCD time is set via internet NTP time server
EthernetNetIf eth;
NTPClient ntp;
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type

int main() {
//system time structure
    time_t ctTime;
    char *time_str;
    //clear LCD
    lcd.cls();
    lcd.locate(0,2);
    // lcd.printf prints to LCD display;
    lcd.printf("Get IP addr...");
    EthernetErr ethErr = eth.setup();
    //Get an Internet IP address using DHCP
    if (ethErr) {
        //error or timeout getting an IP address
        lcd.cls();
        lcd.locate(0,2);
        lcd.printf("Net Error %d",ethErr);
        return -1;
    }
    lcd.locate(0,3);
    lcd.printf("Reading Time...");
    //specify time server URL
    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    //Read time from server
    ntp.setTime(server);
    lcd.locate(0,4);
    lcd.printf("Time set");
    //Delay for human time to read LCD display
    wait(1);
    while (1) {
        // loop and periodically update the LCD's time display
        lcd.cls();
        ctTime = time(NULL);
        lcd.locate(0,1);
        lcd.printf("UTC:");
        lcd.locate(0,3);
        time_str = ctime(&ctTime);
        time_str[strlen(time_str)-1] = 0;
        lcd.printf("%s", time_str);
        wait(1);
    }
}
