#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "TextLCD.h"
// Internet of Things clock example: LCD time is set via internet NTP time server
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d0-d3
EthernetNetIf eth;
NTPClient ntp;

int main() {
//system time structure
    time_t ctTime;
    //clear LCD
    lcd.cls();
    // lcd.printf prints to LCD display;
    lcd.printf("Get IP addr...");
    EthernetErr ethErr = eth.setup();
    //Get an Internet IP address using DHCP
    if (ethErr) {
        //error or timeout getting an IP address
        lcd.cls();
        lcd.printf("Network Error \n\r %d",ethErr);
        return -1;
    }
    lcd.cls();
    lcd.printf("Reading Time...\n\r");
    //specify time server URL
    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    //Read time from server
    ntp.setTime(server);
    lcd.printf("Time set");
    //Delay for human time to read LCD display
    wait(1);
    while (1) {
        // loop and periodically update the LCD's time display
        lcd.cls();
        ctTime = time(NULL);
        lcd.printf("UTC:  %s", ctime(&ctTime));
        wait(.25);
    }
}
