#include "mbed.h"
#include "mlx90614.h"

DigitalOut myled(LED1); //displays I2C wait
I2C i2c(p28,p27);   //sda,scl
Serial pc(USBTX,USBRX);  //serial usb config

MLX90614 IR_thermometer(&i2c);
//setup an MLX90614 using MLX90614 library from
// http://mbed.org/users/aquahika/libraries/MLX90614/lsixz6

float temp; //temperature in degrees C

int main() {
    while (1) {
        myled=1; // if led1 on - waiting on I2C
        if (IR_thermometer.getTemp(&temp)) {
            //gets temperature from sensor via I2C bus
            myled=0;
            //print temperature on PC
            printf("Temperature is %5.1F degrees C\r\n",temp);
        }
        //wait for device to produce next temperature reading
        wait(0.5);
    }
}
