#include "mbed.h"
// The program sends and receives I2C commands using RealTerm's I2C tab feature
// Run Realterm on PC and this program on mbed
// In RealTerm connect to the mbed's USB virtual COM port
// Switch to I2C tab
// Type in I2C address & data to read and write and see the response
// It is handy to debug complex I2C hardware setups
// Prints "No Ack!" when no I2C device responds to the address
//
// See Instructions at http://mbed.org/users/4180_1/notebook/i2c-debug-for-realterm/
//
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
I2C i2c(p9,p10);

int main() {
    char last_command=0;
    char previous_command=0;
    char current_char=0;
    char address=0;
    char data [255];
    char current_byte=0;
    char cmd[255];
    int cmd_count=0;
    int data_count=0;
    int read=0;
    int write=0;
    int first_data_byte=0;
    int i=0;

    myled=1;
    i2c.frequency(75000);
    i2c.start();
    i2c.stop();
    // Send a start message to RealTerm
    pc.printf("\fmbed I2C debug tool ready\n\r");
    // Scan for I2C devices that reply with ack
    for (i=0; i<=254; i=i+2) {
        if (i2c.read(i, &data[0], 1) ==0) printf("I2C device detected at address=%2.2X\n\r", i);
    }
    data[0]=0;
    i2c.start();
    i2c.stop();
// Loop processing command strings from RealTerm
    while (1) {
        current_char = pc.getc();
        // Is it a two character ASCII string data byte value
        if ((current_char <='F') && (current_char !='?')) {
            // convert to a binary byte
            if (current_char <='9') current_byte = current_char - '0';
            else current_byte =current_char +10 -'A';
            current_char = pc.getc();
            if (current_char >'F') pc.printf("error|\n\r");
            if (current_char <='9') current_byte = (current_byte <<4) | (current_char - '0');
            else current_byte = (current_byte <<4)|(current_char +10 -'A');
            // first byte after S command is the I2C address
            if (first_data_byte==1) {
                first_data_byte=0;
                address=current_byte;
                pc.printf(" -I2C address=%2.2X ", address);
                //Odd I2C address is a read and even is a write
                if ((address & 0x01) == 0) write=1;
                else read=1;
            } else
                // Read in cmd bytes for write
                if ((last_command == 'S')&&(read==0)) {
                    cmd[cmd_count]=current_byte;
                    cmd_count++;
                }
            // number of bytes for a read
            if ((last_command =='R')||(read==1)) data_count=current_byte;
        } else {
            // Not a number - it is a command character
            last_command = current_char;
            switch (last_command) {
                    // Start
                case 'S':
                    if (previous_command == 'S') i2c.start();
                    first_data_byte=1;
                    break;
                    // Stop
                case 'P':
                    // Do the I2C write
                    if (write==1) {
                        pc.printf(" write ");
                        if (i2c.write(address,cmd,cmd_count)!=0) pc.printf(" No Ack! ");
                        for (i=0; i<cmd_count; i++)
                            pc.printf(" cmd=%2.2X ", cmd[i]);
                    }
                    // Do the I2C read
                    if (read==1) {
                        pc.printf(" read ");
                        if (i2c.read(address, data, data_count) != 0) pc.printf(" No Ack! ");
                        for (i=0; i<data_count; i++)
                            pc.printf(" data=%2.2X ",data[i]);
                    }
                    // reset values for next I2C operation
                    i2c.stop();
                    pc.printf("\n\r");
                    read=0;
                    data_count=0;
                    cmd_count=0;
                    write=0;
                    first_data_byte=0;
                    break;
                    // Read after write
                case 'R':
                    read=1;
                    break;
                    // Status request
                case '?':
                    pc.printf(" mbed ready \n\r");
                    break;
                    // Unknown or unimplemented command
                default:
                    pc.printf(" unknown command \n\r");
                    break;
            }
            previous_command = last_command;
        }
    }
}