#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NokiaLCD.h"
//Geolocation using IP address - get web page with location data
// displays location fields on LCD  from web page ";....location text...;"
// see http://mbed.org/users/4180_1/notebook/geolocation-nokia-lcd-display/

NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
EthernetNetIf eth;
HTTPClient http;

void parse(char buffer[], int *j, char *string) {
//extracts next location string data item from buffer
    int i=0;
    for (i=0; i<=strlen(buffer); i++) {
        if ((buffer[*j+i] == ';')||(buffer[*j+i] == '\0' )) {
            //semicolon is the string field delimiter
            string[i]=0;
            *j=*j+i+1;
            break;
        } else string[i]=buffer[*j+i];
    }
}

int main() {
    char result [4]={0};
    char ip [17]={0};
    char country_abbr[10]={0};
    char country[60]={0};
    char region[40]={0};
    char city[60]={0};
    char zipcode[10]={0};
    char latitude[10]={0};
    char longitude[10]={0};
    char timezone[7]={0};
    char buffer[256]={0};
    float flatitude=0.0;
    float flongitude=0.0;
    float ftimezone=0.0;
    int j=0;

    //Setup network - get IP address using DHCP
    lcd.cls();
    lcd.locate(0,2);
    lcd.printf("Net setup");
    lcd.locate(0,3);
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("Error %d", ethErr);
        return -1;
    }
    lcd.printf(" Net OK");
    wait(.5);
    lcd.cls();
    lcd.locate(0,2);
    lcd.printf("IP Address");
    lcd.locate(0,3);
    lcd.printf("Geolocation API");
    HTTPText txt;
    //iPinfoDB API  - get web page with location data
    //Insert your free key from www.ipinfo.com for the API in the URL below
    HTTPResult r = http.get("http://api.ipinfodb.com/v3/ip-city/?key=<PUT_YOUR_API_KEY_HERE>", &txt);
    if (r==HTTP_OK) {
        //got web page text data OK
        strcpy(buffer,txt.gets());
        wait(1);
        while (1) {
            j=0;
            //parse and display each of the API's location information strings on the LCD
            parse(buffer, &j, result);
            lcd.cls();
            lcd.locate(0,2);
            lcd.printf("result: %s", result);
            if (result[0]!='O') { //needs valid key
                wait(1);
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("Get Free API key");
                lcd.printf("www.iPinfoDB.com");
                return(-1);
            }
            wait(1);
            j++;
            parse(buffer, &j, ip);
            lcd.locate(0,2);
            lcd.printf("IP address:");
            lcd.locate(0,3);
            lcd.printf(" %s", ip);
            parse(buffer, &j, country_abbr);
            lcd.locate(0,4);
            lcd.printf("Country code:");
            lcd.locate(0,5);
            lcd.printf(" %s", country_abbr);
            parse(buffer, &j, country);
            lcd.locate(0,6);
            lcd.printf("Country:");
            lcd.locate(0,7);
            lcd.printf(" %s", country);
            parse(buffer, &j, region);
            lcd.locate(0,8);
            lcd.printf("Region or State:");
            lcd.locate(0,9);
            lcd.printf(" %s", region);
            parse(buffer, &j, city);
            lcd.locate(0,10);
            lcd.printf("City:");
            lcd.locate(0,11);
            lcd.printf(" %s", city);
            parse(buffer, &j, zipcode);
            lcd.locate(0,12);
            lcd.printf("Zipcode:");
            lcd.locate(0,13);
            lcd.printf("  %s", zipcode);
            wait(5);
            parse(buffer, &j, latitude);
            sscanf(latitude,"%f",&flatitude);
            lcd.cls();
            lcd.locate(0,2);
            lcd.printf("Latitude:");
            lcd.locate(0,3);
            lcd.printf(" %f", flatitude);
            parse(buffer, &j, longitude);
            sscanf(longitude,"%f",&flongitude);
            lcd.locate(0,4);
            lcd.printf("Longitude:");
            lcd.locate(0,5);
            lcd.printf(" %f", flongitude);
            parse(buffer, &j, timezone);
            sscanf(timezone,"%f",&ftimezone);
            lcd.locate(0,6);
            lcd.printf("Timezone:");
            lcd.locate(0,7);
            lcd.printf(" %f", ftimezone);
            wait(4);
        }
    } else {
        lcd.cls();
        lcd.locate(0,2);
        lcd.printf("HTTP Error %d", r);
        return -1;
    }
}
