#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"
//Geolocation using IP address - get web page with location data
// displays location fields on LCD  from web page ";....location text...;"
// see http://mbed.org/users/4180_1/notebook/geolocation-lcd-display/
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d0-d3
EthernetNetIf eth;
HTTPClient http;

void parse(char buffer[], int *j, char *string) {
//extracts next location string data item from buffer
    int i=0;
    for (i=0; i<=strlen(buffer); i++) {
        if ((buffer[*j+i] == ';')||(buffer[*j+i] == '\0' )) {
            //semicolon is the string field delimiter
            string[i]=0;
            *j=*j+i+1;
            break;
        } else string[i]=buffer[*j+i];
    }
}

int main() {
    char result [4]={0};
    char ip [17]={0};
    char country_abbr[10]={0};
    char country[60]={0};
    char region[40]={0};
    char city[60]={0};
    char zipcode[10]={0};
    char latitude[10]={0};
    char longitude[10]={0};
    char timezone[7]={0};
    char buffer[256]={0};
    float flatitude=0.0;
    float flongitude=0.0;
    float ftimezone=0.0;
    int j=0;

    //Setup network - get IP address using DHCP
    lcd.cls();
    lcd.printf("Net setup\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("Error %d", ethErr);
        return -1;
    }
    lcd.printf(" Net OK");
    wait(.5);
    lcd.cls();
    lcd.printf("IP Address\nGeolocation API");
    HTTPText txt;
    //iPinfoDB API  - get web page with location data
    //Insert your free key from www.ipinfo.com for the API in the URL below
    HTTPResult r = http.get("http://api.ipinfodb.com/v3/ip-city/?key=PUT_YOUR_API_KEY_HERE", &txt);
    if (r==HTTP_OK) {
        //got web page text data OK
        strcpy(buffer,txt.gets());
        wait(1);
        while (1) {
            j=0;
            //parse and display each of the API's location information strings on the LCD
            parse(buffer, &j, result);
            lcd.cls();
            lcd.printf("result: %s\n", result);
            if (result[0]!='O') { //needs valid key
                wait(1);
                lcd.cls();
                lcd.printf("Get Free API key");
                lcd.printf("www.iPinfoDB.com");
                return(-1);
            }
            wait(1);
            j++;
            parse(buffer, &j, ip);
            lcd.cls();
            lcd.printf("IP address: \n %s", ip);
            wait(2);
            parse(buffer, &j, country_abbr);
            lcd.cls();
            lcd.printf("Country code: \n %s", country_abbr);
            wait(2);
            parse(buffer, &j, country);
            lcd.cls();
            lcd.printf("Country: \n%s", country);
            wait(2);
            parse(buffer, &j, region);
            lcd.cls();
            lcd.printf("Region or State:%s", region);
            wait(2);
            parse(buffer, &j, city);
            lcd.cls();
            lcd.printf("City: \n%s", city);
            wait(2);
            parse(buffer, &j, zipcode);
            lcd.cls();
            lcd.printf("Zipcode: \n %s", zipcode);
            wait(2);
            parse(buffer, &j, latitude);
            sscanf(latitude,"%f",&flatitude);
            lcd.cls();
            lcd.printf("Latitude: \n %f", flatitude);
            wait(2);
            parse(buffer, &j, longitude);
            sscanf(longitude,"%f",&flongitude);
            lcd.cls();
            lcd.printf("Longitude: \n %f", flongitude);
            wait(2);
            parse(buffer, &j, timezone);
            sscanf(timezone,"%f",&ftimezone);
            lcd.cls();
            lcd.printf("Timezone: \n %f", ftimezone);
            wait(4);
        }
    } else {
        lcd.cls();
        lcd.printf("HTTP Error %d", r);
        return -1;
    }
}
