#include "mbed.h"
// EasyVR Speech Recognition and Speech Synthesis Demo
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial device(p13, p14);  // tx, rx
Serial pc(USBTX,USBRX); //USB virtual com port can be used to watch VR command responses

// Function to play a sound file on speaker
void speak(int num) {
    device.putc('w');
    // small delay is needed between characters
    wait(.001);
    device.putc('A' + num/32);
    wait(.001);
    device.putc('A' + num%32);
    wait(.001);
    device.putc('P');
    while (device.getc()!='o') {}
    wait(.25);
}

int main() {
    char rchar=0;
    char echar=0;
    led1=0;
    led2=0;
    led3=0;
    led4=0;
// wake up EasyVR
    device.putc('b');
    while (device.getc()!='o') {
        device.putc('b');
        wait(0.1);
    }
    // play reset message
    speak(3);
// Use SD recogniton and wait for password (mbed)
    while (rchar!='A') {
        wait(.001);
        device.putc('d');
// a small delay is needed when sending EasyVR several characters
        wait(.001);
        device.putc('B');
        while (device.readable()!=0) {}
        rchar=device.getc();
        pc.putc(rchar);
        // word recognized
        if (rchar=='r') {
            wait(.001);
            device.putc(' ');
            rchar=device.getc();
            pc.putc(rchar);
        // error
        } else if (rchar=='e') {
            wait(.001);
            device.putc(' ');
            rchar=device.getc();
            device.putc(' ');
            rchar=device.getc();
        }
    }
// voice ack for password
    speak(5);
    wait(1);
// loop forever waiting for number commands
    while (1) {
    // voice prompt for input - don't prompt after a timeout or error
        if ((rchar!='t')&&(rchar!='e')) speak(1);
        wait(.002);
    // SI recog of numbers 0..10
        device.putc('i');
        wait(.001);
        device.putc('D');
        while (device.readable()!=0) {}
        rchar=device.getc();
        pc.putc(rchar);
    // number was recognized
        if (rchar=='s') {
            wait(.001);
            device.putc(' ');
            rchar=device.getc();
            pc.putc(rchar);
            if (rchar=='B') led1 = !led1;
            if (rchar=='C') led2 = !led2;
            if (rchar=='D') led3 = !led3;
            if (rchar=='E') led4 = !led4;
            // voice ack
            speak(2);
    // recognition error
        } else if (rchar=='e') {
            wait(.001);
            device.putc(' ');
            echar=device.getc();
            device.putc(' ');
            echar=device.getc();
            // prompt user to restate command
            speak(4);
        }
    }
}
