#include "mbed.h"
//BlHeli Cable (mbed FTDI) see manual for 1-pin hookup - needs resistor? and diode!
//worked without resistor on my setup
//See https://developer.mbed.org/users/4180_1/notebook/using-a-dc-brushless-motor-with-an-rc-esc/
RawSerial  pc(USBTX, USBRX);
RawSerial  dev(p9, p10);
DigitalOut led1(LED1);
DigitalOut led4(LED4);
 
void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}
 
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}
 
int main()
{
    pc.baud(19200);
    dev.baud(19200);
 
    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
 
    while(1) {
        sleep();
    }
}