#include "mbed.h"

AnalogOut aout(p18);
AnalogIn ain(p20);
// Jumper p18 to p20 for analog loopback test
BusOut led_state(LED1, LED2, LED3, LED4);
// Analog input connected to analog output will display in LED Bar Graph
int LED_BarGraph(float max_value, float value);

int main() {
    while (1) {
        for (float i=0.0; i<1.0; i+=0.1) {
            aout = (1 + sin(i*2*3.14159265))/2;
            LED_BarGraph(1.0, ain);
            wait(0.1);
        }
    }
}

int LED_BarGraph(float max_value,float value) {
    int scale;
    scale = (value*4.5)/max_value;
    switch (scale) {
        case 0:
            led_state = 0x00;
            break;
        case 1:
            led_state = 0x01;
            break;
        case 2:
            led_state = 0x03;
            break;
        case 3:
            led_state = 0x07;
            break;
        default:
            led_state = 0x0F;
            break;
    }
    return 0;
}