#include "mbed.h"
#include "EthernetInterface.h"

// Network interface
EthernetInterface net;

// Socket demo
int main() {
    // Bring up the ethernet interface
    printf("\n\rEthernet socket example\n\r");
    net.connect();

    // Show the network address
    const char *ip = net.get_ip_address();
    printf("IP address is: %s\n\r", ip ? ip : "No IP");

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    TCPSocket socket;
    socket.open(&net);
    socket.connect("hamblen.ece.gatech.edu", 80);

    // Send a simple http request
    char sbuffer[] = "GET /hello.txt HTTP/1.1\r\nHost: hamblen.ece.gatech.edu\r\n\r\n";
    int scount = socket.send(sbuffer, sizeof sbuffer);
    //print out packet
    printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);

    // Recieve a simple http response and print out the response line and text
    char rbuffer[400]; //enough for a very short text page - almost out of RAM!
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\n\r", rcount, strstr(rbuffer, "\r\n"), rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();

    // Bring down the ethernet interface
    net.disconnect();
    printf("Done\n");
}
