#include "mbed.h"
// Need include below to add the RTOS
#include "rtos.h"
//#include "EthernetInterface.h" //needed for Extra Credit
//#include "NTPClient.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "TMP36.h"
#include "wave_player.h"
// Setup four builtin leds for use by threads
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AnalogOut DACout(p18); // used to play sound on speaker

//wave player plays a *.wav file to D/A and a PWM
wave_player waver(&DACout);

uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin;

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card setup


// Setup function code for three new threads to run.
// Put in a while loop so that threads run forever.
// Thread::wait will force at least a "x" millisecond
// wait before the thread runs again. During this delay
// the other threads will run
// DO NOT use wait() with the RTOS!!!!!
// wait just burns processor time and no other threads run
void led2_thread(void const *argument)
{
    led2 = 1;
    while (true) {
        led2 = !led2;
        Thread::wait(2000);
    }
}
void led3_thread(void const *argument)
{
    led3 = 1;
    while (true) {
        led3 = !led3;
        Thread::wait(4000);
    }
}
void led4_thread(void const *argument)
{
    TMP36 myTMP36(p20);
    led4 = 1;
    while (true) {
        led4 = !led4;
        Thread::wait(8000);
    }
}

int main()
{
    led1 = 1;
// code to set time in extra credit option goes here
//
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    uLCD.text_width(2); //2x size text
    uLCD.text_height(2);
// Create 3 new thread objects thread1, thread2, and thread3
// The RTOS will immediately start running them
    Thread thread1(led2_thread);
    Thread thread2(led3_thread);
    Thread thread3(led4_thread);
// Main continues to run and is actually the first thread.
// So a total of four threads are running now.
// Each thread blinks an LED, but at a different rate
// because of the different values used in Thread::wait().
//
// Set time in seconds since Jan 1 1970 (Unix style)
// must set time to start Real Time clock running
    set_time(1286729737);
    char buffer[12];
    time_t seconds;
    while (true) {
// reads time structure
        seconds = time(NULL);
// converts time structure to a string
        strftime(buffer, 12, "%T", localtime(&seconds));
// print time HH:MM:SS
        uLCD.locate(0,2);
        uLCD.printf("%s\n\r", buffer);
        led1 = !led1;
        Thread::wait(1000);
    }
}
