#include "mbed.h"
#include "C12832_lcd.h"
#include "stdio.h"
#include "string.h"
#include "stdint.h"
#include "stdlib.h"
#include "time.h"

C12832_LCD lcd; 
Serial pc(USBTX, USBRX);

char testStringBuffer[150];
 
#define NUM_FIELDS  (12) 
char* pFields[NUM_FIELDS];
 
void ParseFields(char* inputBuffer, char** pFields, uint32_t numFields, char* delimiterChars)
{
    char* pString = inputBuffer;
    char* pField;
    
    for(uint32_t i=0; i<numFields; i++)
    {
        pField = strtok(pString, delimiterChars);
 
        if(pField != NULL)
        {
            pFields[i] = pField;
        }
        else
        {
            pFields[i] = "";
        }
 
        pString = NULL; 
    }
}

int main(int argc, char* argv[])
{
    pc.baud(4800);
    
    while(1)
    {
        pc.scanf("&s", &testStringBuffer);
        ParseFields(testStringBuffer, pFields, NUM_FIELDS, ",");
        lcd.cls();
        lcd.locate (0,0);
        lcd.printf("%s", pFields[1]);
    }

    return 0;
}
 

    

