#include "mbed.h"

Serial pc(USBTX, USBRX);

AnalogIn input(p20);
InterruptIn int_reset(p21);
DigitalOut myled(LED1);

int reset; // init enable 
int i; // time counter (*10sec)
int sum_time; // reset time
double bat_volt; // touch pen battery (0.0 --> 1.0 * 3.3V)  


void reset_det() {

    reset = 1;           
    sum_time = i * 10;

}


int main() {

    // initialize
    reset = 0;
    i = 0;
    sum_time = 0;
    bat_volt = 0;

    int_reset.fall(&reset_det); // interrupt

    while(1) {

       bat_volt = input.read() * 3.3;       
       wait(10);
       i++;
       myled = !myled;    
  
       if (reset == 0)        
           pc.printf("time = %d sec, reset time = %d, battery volt = %f V\r\n",i*10,sum_time,bat_volt);                       
       else         
           pc.printf("---reset detect--- : time = %d sec, reset time = %d, battery volt = %f V\r\n",i*10,sum_time,bat_volt);                                
       
    }
}
