//**********************************************************************
#include "mbed.h"
#include "TextLCD.h"

#include "star.h"
#include "square.h"
#include "jibanyan.h"

#include "crescent_moon_edge.h"
#include "crescent_moon_mesh.h"


#include "blktest.h"
#include "blktest2.h"

#include "square_160x120_raster.h"
#include "square_160x120_vector.h"
#include "square_160x120_vector_half.h"
#include "square_160x120_hybrid.h"

#include "square_full_vector.h"
#include "square_L_vector.h"
#include "square_M_vector.h"
#include "square_S_vector.h"


#include <stdlib.h>


Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p26, p25, p24, p23, p22, p21); // rs, e, d4-d7

SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut CS(p10);
DigitalOut LDAC(p9);

DigitalOut BLK(p8); // laser blanking

#define CHA 0x7000 // //0x0000  //0x7000
#define CHB 0xF000 // //0x8000  //0xF000
#define BLK_DELAY 80 // < 100 default
//#define BLK_DELAY 160 // < 100


//**********************************************************************

void    mcp4922DataSet(char ch,  uint16_t dt)
{
    if (dt >= 4096) {
        //return;
        dt = dt &0x0FFF;
    }
    //return;
    //
    if (ch == 'A') {
        dt = CHA | dt ;  //dt = 0b0111000000000000 | dt;
    } else {
        dt = CHB | dt ;  //dt = 0b1111000000000000 | dt;
    }
    //
    CS = 0;

    spi.write(dt);
    //LPC_SSP0->DR = dt; // | 0x10000; //hardware dependent
    //while(1) {
    //    if( (LPC_SSP0->SR &0x13) == 3) break;
    //}

    CS = 1;
}

//**********************************************************************

void    mcp4922Init()
{
    CS = 1;
//    SCK = 0;
//    SDI = 0;
    CS = 0;
    LDAC = 1;
    //
    mcp4922DataSet('A', 0);
    mcp4922DataSet('B', 0);
}



void high_flat(void)
{
    while(1) {
        mcp4922DataSet('A', 4095);//wait_us(20);
        mcp4922DataSet('B', 4095);//wait_us(20);

        LDAC = 0;
        LDAC = 1;
        wait_us(100);
    }
}


void triangle2(void)
{
    int i=0;

    while(1) {
        i++;
        if (i == 256) i = 0;
        else if (i < 128) {
            mcp4922DataSet('A', (i<<1)<<4);//wait_us(20);
            mcp4922DataSet('B', (i<<1)<<4);//wait_us(20);
        } else {
            mcp4922DataSet('A', ((255 - i)<<1)<<4);//wait_us(20);
            mcp4922DataSet('B', ((255 - i)<<1)<<4);//wait_us(20);
        }
        LDAC = 0;
        LDAC = 1;
        BLK = i % 2;
        wait_us(100);
    }
}


/*
void star(void)
{
    int i=0;
    uint16_t x,y;

    while(1) {
        x = star001[i++];
        y = star001[i++];
        if (x == 0 && y == 0) {
            i = 0;
        }
        x += 32767;
        y += 32767;
        x = 65535 - x; // X-axis invert
        mcp4922DataSet('A', x>>4);//wait_us(20);
        mcp4922DataSet('B', y>>4);//wait_us(20);
        LDAC = 0;
        LDAC = 1;
        wait_us(100);

    }
}
*/
/*
void jibanyan(void)
{
    int i=0;
    uint16_t x,y;

    while(1) {
        x = jibanyan001[i++];
        y = jibanyan001[i++];
        if (x == 0 && y == 0) {
            i = 0;
        }
        x += 32767;
        y += 32767;
        x = 65535 - x; // X-axis invert
        mcp4922DataSet('A', x>>4);//wait_us(20);
        mcp4922DataSet('B', y>>4);//wait_us(20);
        LDAC = 0;
        LDAC = 1;
        wait_us(100);

    }
}
*/

/*
void square(void)
{
    int i=0;
    uint16_t x,y;
    bool b;

    while(1) {
        b = square001[i++];
        x = square001[i++];
        y = square001[i++];
        if (x == 0 && y == 0) {
            i = 0;
        }
        x += 32767;
        y += 32767;
            mcp4922DataSet('A', x>>4);//wait_us(20);
            mcp4922DataSet('B', y>>4);//wait_us(20);
            LDAC = 0;
            LDAC = 1;
        BLK = b;
//        wait_us(400);
        wait_us(2000);

    }

}
*/



/*
void square(void)
{
    int i=0;
    uint16_t x,y;

    while(1) {
        x = square001[i++];
        y = square001[i++];
        if (x == 0 && y == 0) {
            i = 0;
        }
        x += 32767;
        y += 32767;
        x = 65535 - x; // X-axis invert
        mcp4922DataSet('A', x>>4);//wait_us(20);
        mcp4922DataSet('B', y>>4);//wait_us(20);
        LDAC = 0;
        LDAC = 1;
        wait_us(100);

    }

}
*/





Ticker timer;

uint8_t CNT=0;
// timer.attach(&int_timer, 1); // 1 second
void int_timer(void)
{
    CNT++;
}



void laserscan(const int *p, const int num)
{
    int i = 0;
    uint16_t x,y = 0;
    
//        while(1) {
          while(CNT < 5) {
            
            x = *(p + i++);
            y = *(p + i++);    

//            if (x == 0 && y == 0) {
//                i = 0;
//            }

            if (i == num) {
                i = 0;
            }

            x += 32767;
            y += 32767;
            x = 65535 - x; // X-axis invert

            mcp4922DataSet('A', x>>4);//wait_us(20);
            mcp4922DataSet('B', y>>4);//wait_us(20);

            LDAC = 0;
            LDAC = 1;

            wait_us(100);        
        }
        CNT = 0;
}  


// add laser blanking control
void laserscan_blk(const int *p, const int num)
{
    int i = 0;
    uint16_t x,y = 0;
    bool b = 0;
    
//        while(1) {
          while(CNT < 5) {
            
            b = *(p + i++);
            x = *(p + i++);
            y = *(p + i++);    

//            if (x == 0 && y == 0) {
//                i = 0;
//            }

            if (i == num) {
                i = 0;
            }

            x += 32767;
            y += 32767;
            x = 65535 - x; // X-axis invert

            mcp4922DataSet('A', x>>4);//wait_us(20);
            mcp4922DataSet('B', y>>4);//wait_us(20);
            LDAC = 0;
            LDAC = 1;

            wait_us(BLK_DELAY);
//            BLK = b;
                BLK = 1;
                
            wait_us(200 - BLK_DELAY);        // default
//            wait_us(400 - BLK_DELAY);        

        }
        CNT = 0;
}  


// serial com test
void laserscan_com(void)
{
    int i = 0;
    int buff[4] = {0,0,0,0};
    uint16_t x,y = 0;
    
        while(1) {

        for (i = 0; i < 4; i++) {
            char c = pc.getc();
            buff[i] = c;
//            lcd.printf("%02X",buff[i]);

        }

//        lcd.printf("\n");

        x = (buff[1] << 8) + buff[0];
        y = (buff[3] << 8) + buff[2];
//        lcd.printf("x=%04X,y=%04X\n",x,y);
        
            if (x == 0 && y == 0) {
                i = 0;
            }

            x += 32767;
            y += 32767;
            x = 65535 - x; // X-axis invert

            mcp4922DataSet('A', x>>4);//wait_us(20);
            mcp4922DataSet('B', y>>4);//wait_us(20);

            LDAC = 0;
            LDAC = 1;

            wait_us(100);       
        }
}  





int main(void)
{

    spi.format(16,0);
    spi.frequency(20000000);

    pc.baud(230400);

    mcp4922Init();
    
    timer.attach(&int_timer, 1);
    
/*
    while(1) {
        char c = pc.getc();
        lcd.printf("%02X",c);

//            char str[] = "145";
//            int buff = atoi(str);
//            lcd.printf("%02X",buff);
            
        laserscan(c);

        }
*/

//    triangle2();
//        high_flat();

    while(1) {

// non blanking control
//        laserscan(jibanyan,jibanyan_dnum);
//        laserscan(star,star_dnum);
//        laserscan(crescent_moon_edge,crescent_moon_edge_dnum);
//        laserscan(crescent_moon_mesh,crescent_moon_mesh_dnum);

// add blanking control
//       laserscan_blk(blktest2,blktest2_dnum);
//       laserscan_blk(square_20x20_raster,square_20x20_raster_dnum);
//       laserscan_blk(square_160x120_raster,square_160x120_raster_dnum);
//       laserscan_blk(square_160x120_vector,square_160x120_vector_dnum);
//       laserscan_blk(square_160x120_vector_half,square_160x120_vector_half_dnum);
//       laserscan_blk(square_160x120_hybrid,square_160x120_hybrid_dnum);
//       laserscan_blk(square_full_vector,square_full_vector_dnum);
       laserscan_blk(square_L_vector,square_L_vector_dnum);
       laserscan_blk(square_M_vector,square_M_vector_dnum);
       laserscan_blk(square_S_vector,square_S_vector_dnum);



// add PC serial com
//        laserscan_com();
    }


}



