

#ifndef _WatchdogManager_h_
#define _WatchdogManager_h_

#include "mbed.h"

// The STM32F411's IWDT only goes up to about 32 seconds, but some modem operations take that long.
// I want the WDT to trip after maybe 120-300 seconds instead, and only be fed from the main() loop.
// To do this, I'll have a 1Hz background ticker that actually feeds the HW WDT, but only when the
// 32-bit m_watchdogCount value is below the cutoff.

class WatchdogManager
{
    private:
    static volatile int m_watchdogCount;
    static Ticker m_ticker;
    
    static void m_serviceWatchdog()
    {
        volatile unsigned int &IWDG_KR = *(volatile unsigned int*)0x40003000;
        if (m_watchdogCount++ < 120)
        {
            IWDG_KR = 0xAAAA;
        }
        else
        {
           printf("WDT Ticker letting IWDT lapse, value %d\r\n",  m_watchdogCount);  
        }
    }
    
public:
    
    static bool Initialize()
    {
        volatile unsigned int &IWDG_KR = *(volatile unsigned int*)0x40003000;
        volatile unsigned int &IWDG_PR = *(volatile unsigned int*)0x40003004;
        volatile unsigned int &IWDG_RLR = *(volatile unsigned int*)0x40003008;
        // Not used: volatile unsigned int &IWDG_SR = *(volatile unsigned int*)0x4000300C;
        m_watchdogCount = 0;
        IWDG_KR = 0x5555;
        IWDG_RLR = 0x4FF; // about 12 seconds of HW WDT timeout
        IWDG_KR = 0x5555;
        IWDG_PR = 0x6; // div-by-256
        IWDG_KR = 0xCCCC;
        IWDG_KR = 0xAAAA;
        m_ticker.attach(m_serviceWatchdog, 1);
        return true;
    }
    
    static void Feed()
    {
        __disable_irq();
        m_watchdogCount = 0;
        __enable_irq();
    }
    
};


#endif

