
#ifndef _SystemTimeKeeper_h_
#define _SystemTimeKeeper_h_

#include <stdint.h>

class SystemTimeKeeper
{
public:
    SystemTimeKeeper() :
        m_uptimeCount(0),
        m_wallTimeDelta(0)
    {
        m_instance = this; //singleton init
    }
    
    void reset()
    {
        m_uptimeCount = 0;
        m_wallTimeDelta = 0;    
    }
    
    int64_t advance()
    {
        return ++m_uptimeCount;
    }

    int64_t uptime() const
    {
        return m_uptimeCount;
    }
    
    int64_t walltime() const
    {
        if (hasWalltime())  return m_uptimeCount + m_wallTimeDelta;
        return 0;
    }

    void setWalltime(int64_t wallTime)
    {
        m_wallTimeDelta += (wallTime - (m_wallTimeDelta + m_uptimeCount));
    }

    bool hasWalltime() const
    {
        return m_wallTimeDelta != 0;
    }
    
    int64_t walltimeDelta() const
    {
        return m_wallTimeDelta;
    }
    
    static SystemTimeKeeper& instance()
    {
        return *m_instance;
    }

private:
   int64_t m_uptimeCount; // seconds of up time, never rolls over
   int64_t m_wallTimeDelta; // what you add to m_uptimeCount to get a Jan 1 1970 epoch-based time_t value
   
   static SystemTimeKeeper* m_instance;
};

#endif //_SystemTimeKeeper_h_
