
#ifndef _SystemSerialNumber_h_
#define _SystemSerialNumber_h_

#include <string.h>

char* getSystemSerialNumber()
{
    const size_t serialNumberLength = 25; //96 bits / (8 bits/byte) * 2 chars/byte + 1 for termating 0
    static bool gotSerialNumber = false;
    static char serialNumber[serialNumberLength] = { 0 };
    if (!gotSerialNumber)
    {
        // From STM32F411 Reference Manual section 24.1 ("Unique device ID register (96 bits)")
        volatile uint32_t* sysID = (volatile uint32_t*)0x1FFF7A10;
        snprintf(serialNumber, serialNumberLength, "%08X%08X%08X",
            sysID[0],
            sysID[1],
            sysID[2]);
        gotSerialNumber = true;
    }
    return serialNumber;
}



#endif //_SystemSerialNumber_h_
