

#ifndef _StealthPowerSample_h_
#define _StealthPowerSample_h_

class StealthPowerSample
{
public:

    enum Trigger
    {
        TriggerNone = 0,
        TriggerInterval = 1,
        TriggerDischarge = 2,
        TriggerCharge = 3,
    };

    StealthPowerSample() :
        m_trigger(TriggerNone),
        m_beginTimestamp(0),
        m_endTimestamp(0),
        m_Vsp(0),
        m_Voem(0),
        m_V3(0),
        m_V4(0),
        m_A1(0),
        m_A2(0),
        m_sampleCount(0),
        m_dischargeCount(0),
        m_chargeCount(0)
    {
    }

    Trigger m_trigger;
    int64_t m_beginTimestamp;
    int64_t m_endTimestamp;
    float m_Vsp;
    float m_Vsp_min;
    float m_Vsp_max;
    float m_Voem;
    float m_Voem_min;
    float m_Voem_max;
    float m_V3;
    float m_V3_min;
    float m_V3_max;
    float m_V4;
    float m_V4_min;
    float m_V4_max;
    float m_A1;
    float m_A1_min;
    float m_A1_max;
    float m_A2;
    float m_A2_min;
    float m_A2_max;
    float m_temperatureAvg;
    float m_temperatureMin;
    float m_temperatureMax;
    uint32_t m_sampleCount;
    uint32_t m_dischargeCount;
    uint32_t m_chargeCount;

    bool operator == (const StealthPowerSample& other) const
    {
        // Note, this is an imperfect comparison because there are many other
        // values in the class.  But these should be enough to uniquely identify
        // the sample, and avoids a lot of potentially nasty floating point NaN/
        // Inf corner cases to check for.
        return m_trigger == other.m_trigger &&
               m_beginTimestamp == other.m_beginTimestamp &&
               m_endTimestamp == other.m_endTimestamp &&
               m_dischargeCount == other.m_dischargeCount &&
               m_chargeCount == other.m_chargeCount &&
               m_sampleCount == other.m_sampleCount;
    }
};


#endif //_StealthPowerSample_h_
