

#ifndef _StealthPowerStatusUpdate_h_
#define _StealthPowerStatusUpdate_h_

#include <string>

class StealthPowerStatusUpdate
{
public:
    StealthPowerStatusUpdate() :
        m_atTimestamp(0),
        m_picState(0),
        m_picK(0),
        m_batteryState(0),
        m_error(0),
        m_message(),
        m_Vsp(0),
        m_Voem(0),
        m_V3(0),
        m_V4(0),
        m_A1(0),
        m_A2(0),
        m_temperature(0)
    {
    }

    int64_t m_atTimestamp;
    int8_t m_picState;
    int8_t m_picK;
    int8_t m_batteryState;
    int32_t m_error;
    std::string m_message;
    int32_t m_Vsp;
    int32_t m_Voem;
    int32_t m_V3;
    int32_t m_V4;
    int32_t m_A1;
    int32_t m_A2;
    int32_t m_temperature;
    
    bool operator == (const StealthPowerStatusUpdate& other) const
    {
        return m_atTimestamp == other.m_atTimestamp &&
               m_picState == other.m_picState &&
               m_picK == other.m_picK &&
               m_batteryState == other.m_batteryState &&
               m_error == other.m_error &&
               m_message == other.m_message &&
               m_Vsp == other.m_Vsp &&
               m_Voem == other.m_Voem  &&
               m_V3 == other.m_V3 &&
               m_V4 == other.m_V4 &&
               m_A1 == other.m_A1 &&
               m_A2 == other.m_A2 &&
               m_temperature == other.m_temperature;
               
    }
};


#endif //_StealthPowerStatusUpdate_h_
