
#ifndef _SecondTimer_h_
#define _SecondTimer_h_

#include "mbed.h"
#include "SystemTimeKeeper.h"


// mbed's Timer class on goes up to about 35 minutes (2^31 ticks @ 1us);
// we need something low-res that can wait all day.
class SecondTimer
{
public:
    SecondTimer() : m_started(false), m_startedAt(0), m_count(0) { }
 
    float read() const
    {
        uint32_t result = m_count;
        if (m_started) result += (SystemTimeKeeper::instance().uptime() - m_startedAt);
        return result;
    }
    
    void start()
    {
        m_started = true;
        m_startedAt = SystemTimeKeeper::instance().uptime();
    }
    
    void stop()
    {
        if (m_started) m_count += (SystemTimeKeeper::instance().uptime() - m_startedAt);
        m_started = false;
    }
    
    void reset()
    {
        // Don't stop it if it's running.
        m_count = 0;
        m_startedAt = SystemTimeKeeper::instance().uptime();
    }
    
private:
    bool m_started;
    uint32_t m_startedAt;
    uint32_t m_count;
};


#endif //_SecondTimer_h_
