
#include "RadarSocketManager.h"
#include "StealthRadarAPI.h"

// Implement the Radar API send/recv callbacks and plug them into the RadarSocketManager that
// owns the socket
int Radar_SendBytes(
   const void* bytes,
   size_t size,
   uint32_t timeoutMS)
{
    return RadarSocketManager::instance()->sendBytes(bytes, size, timeoutMS);
}

int Radar_Flush(uint32_t timeoutMS)
{
    return RadarSocketManager::instance()->flush(timeoutMS);
}


int Radar_RecvBytes(
   void* bytes,
   size_t maxSize,
   uint32_t timeoutMS)
{
    return RadarSocketManager::instance()->recvBytes(bytes, maxSize, timeoutMS);
}

uint32_t Radar_RecvResetChecksum()
{
    return RadarSocketManager::instance()->recvResetChecksum();
}

RadarSocketManager* RadarSocketManager::m_instance = NULL;
