

#include "PICManager.h"

PICManager* PICManager::m_instance = NULL;;


// These global function callbacks are invoked during PICConsumePacket() when they are decoded
// respectively.  All they do is find the PICManager instance and delegate to it.
PIC_result_t PICTransmitCallback(
   const char* bytes,
   size_t count)
{
    return PICManager::instance()->TransmitCallback(bytes, count);
}

PIC_result_t PICParametricDataCallback(
   char type,
   int state,
   int Vsp,
   int Voem,
   int V3,
   int V4,
   int A1,
   int A2,
   int K)
{
    return PICManager::instance()->ParametricDataCallback(type, state, Vsp, Voem, V3, V4, A1, A2, K);
}

PIC_result_t PICConfigurationDataCallback(
   int version,
   int Vcutoff,
   int Vcharge,
   int Tdisch,
   int ProgSel)
{
    return PICManager::instance()->ConfigurationDataCallback(version, Vcutoff, Vcharge, Tdisch, ProgSel);
}
