
#ifndef _PICInterface_h_
#define _PICInterface_h_

#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>

enum PICResult
{
   PICResultOK = 0,
   PICResultPacketFormatError = -3001,
   PICResultPacketChecksumError = -3002,
   PICResultPacketUnknownError = -3003,
   PICResultPacketParameterError = -3004,
   PICResultPacketTransmitError = -3005,
};

typedef int PIC_result_t;


PIC_result_t PICConsumePacket(const char* packet);

// External Transmit-Over-Wire Function
// Caller defines this
PIC_result_t PICTransmitCallback(
   const char* bytes,
   size_t count);

PIC_result_t PICParametricDataCallback(
   char type,
   int state,
   int Vsp,
   int Voem,
   int V3,
   int V4,
   int A1,
   int A2,
   int K);

PIC_result_t PICConfigurationDataCallback(
   int version,
   int Vcutoff,
   int Vcharge,
   int Tdisch,
   int ProgSel);

PIC_result_t PICTransmitRequestConfigPacket();

#endif //_PICInterface_h_
