/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 
 ECE595 Design with embeded systems
 Project: Car simulator
 by: Charles White & Lammar Lee
 
 Car simulator able to simulate some of the basic peripherals
  
 
 */

#include "mbed.h"
#include <iostream>
#include <string>
#include "DCMotor.h"
#include "DigitalOutEx.h"
#include "TextLCD.h"
#include "Ultrasonic.h"
#include "DebounceIn.h"
#include "platform/mbed_thread.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

//Push Buttons
DebounceIn StartBtn(D0);    //Start Btn
DebounceIn My_Btn2(D2);      // Motor Btn
DebounceIn BtnBlnkL(D6);     //Blinker liket Btn

//Light system 
DigitalOutEx StartLED(D1);
DigitalOutEx BlnkL(D4);

//sensor
DebounceIn backUpBtn(D15);
DigitalIn echo(D5);
DigitalOutEx trigger(D7); //
DigitalOutEx backLight(LED1); //used for reverse


//Motor
DigitalOutEx DCM(D3);

//LCD
TextLCD lcd(D8, D9, D10, D11, D12, D13);

bool status;

//proto
void backUp(void);
void blinkLights(void);
void LCD(const char*);
void accelerate(void);
void startVic(void);

//back up function
Ultrasonic sensor(D7, D5);
bool btnStatus = false;
void backUp(void){
    if (backUpBtn.read() == 0){ 
        btnStatus = !btnStatus;
    }
    if (btnStatus == true){
        backLight = !backLight;
        lcd.printf("Distance: %d\n",sensor.read_cm());
        accelerate();
        blinkLights();
        wait_us(50);
    }
}

//blinker
void blinkLights(void){
    if(BtnBlnkL.read() == 1){
        if(BlnkL.is_flashing()){
            BlnkL.stop_flashing();
            wait_us(50);
        }
        else{
            BlnkL.flash();
            wait_us(50);
        }
    }
}

//allow to print on the LCD   
void LCD(const char* text){
    //clear the screen
    lcd.cls();
    //enter text
    lcd.printf(text);
};

void accelerate(void){
    if(My_Btn2.read() == 1){
        DCM.write(0);
    }
    else{
        DCM.write(1);
    }
};

/*it will allow all the systems to be functional.
*the start button need to be press in order to start the car.
*if the start button is pressed again it will shut down the system.*/
void startVic(void){
    if (StartBtn.read()== 1){
        status = !status;
    }
    //it will allow all the systems to function. 
    if (status == true){
        StartLED = 1;
        LCD("System\nRunning\n");
    }
    //anyperiferical connected will not work.
    else{
        StartLED = 0;
       LCD("Push button\nto start\n");
    }  
    if (status){
        accelerate();
        blinkLights();
        backUp();
    }  
};



int main()
{
    StartBtn.mode(PullDown);
    backUpBtn.mode(PullDown);
    My_Btn2.mode(PullDown);
    BtnBlnkL.mode(PullDown);
    lcd.cls();
    lcd.printf("System\nInitializing\n");
    ThisThread::sleep_for(600);
    while(true){
        startVic();
        ThisThread::sleep_for(125);
    }               
     
}