/* --------------------------------------------------------------------------
// test compile ok 31/07/2020 

// 30/08/2020 : emission CAN OK en Wifi sur tasmota ou udp bridge
//              mais pb reception caracteres sur port serie ( idem port series pc ouu serial 7

// 02/08/2020
// add sd parameters: read ok
// ip address
// ethernet actif
// wifi actif
// can actif
// serial actif
// fonction
// Touche1 status (0/1)
// Touche1 backcolor
// touche1 text color
// Touche1 text
// Touche1 text1
// Touche2
// Touche3
// Touche4
// Temp1 text
// Temp2 text

// works ok 31/07/2020
// updated package from jpa
// added fonts in  bsp_disco_f746ng/utilities/fonts
// fonts.h updated to manage added fonts
// grovestream.cpp & grovesttream.h updated
// remove stm32746ng_dicovery_sd in /bsp_disco_f746ng/drivers/stm32746ng_discovery
// mainSDAcardJPA issue: add sdcardjpa.cpp in lib /sdfilesystem_warning_fixed
// isue with big fonts: replace /bsp_disco_f746ng/drivers/stm32746ng-discovery/stm32746ng-discovery_lcd.c &.h

// need to add CAN and WiFi

 STM32F746 GroveStreams Stream Feed via Ethernet

 This GroveStreams example is designed for the STM32F746.
 https://www.grovestreams.com/developers/getting_started_stm32F746.html

 The STM32 uses DHCP and DNS for a simpler network setup.

*/

#if !FEATURE_LWIP
#error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "LcdDiscoF746NgTracer.h"
#include "GroveStreams.h"
#include "MbedJSONValue.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "CANMsg.h"

#include "main.h"

//#include "touchScreen.cpp"
int touchInitJPA1();
int touchJPA1();
int touchInitGuiJPA1();
int sendTouchJPA(int xx);
time_t lastToucheTime = 0;
int touchButtonJPA1(int numButton);

//#include "GuiJPA.cpp"
int initDisplayTemp();
int initDatasGuiJPA();
int setTemp1(std::string temp1);
int setTemp2(std::string temp2);
int sendInitDatasJPA(int xx);

//#SDCARD
int mainSDCardJPA(); //in sdcardjpa.cpp in lib /sdfilesystem_warning_fixedd

//GroveStreams Stream IDs. Stream IDs tell GroveStreams which component streams the values will be assigned to.
//Don't change these unless you edit your GroveStreams component definition and change the stream IDs to match these.
const char gsStreamId1[] = "voltage";
const char gsStreamId2[] = "temperature";
char gsStreamIPdatas[] = "192.168.1.49";
char ethernet_actif[] = "O";
char wifi_actif[] = "O";
char can_actif[] = "O";
char serial_actif[] = "O";
char read_sd[] = "";
uint8_t text2[30];
uint8_t             counter = 0;
float               voltage;
const int kMaxBufferSize = 100;
char      buffer[kMaxBufferSize];
int       len = 0;
int i = 0;
int idx_ser =0;
int recv_ser = 0;
Timer               timer;
AnalogIn        analogIn(A0);

// CAN ------------------------------------------------------------
CAN        can(PB_8, PB_9);  // CAN Rx pin name, CAN Tx pin name
CANMsg     rxMsg;
CANMsg     txMsg;

// Other Settings
int updateFrequency = 20;    // Update frequency in seconds. Change this to change your sample frequency.

AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
DigitalOut myled(LED1);

// serial port sur connecteur arduino (D0,D1)--------------------
Serial    pc(USBTX, USBRX);    // serial PC
Serial    serial2(PC_6, PC_7); // TX, RX for udp bridge
Serial    serial7(PF_7, PF_6); // TX, RX for extension

#define BOARD1                  1       // comment out this line when compiling for board #2
#if defined(BOARD1)
    const unsigned int  RX_ID = 0x100;
    const unsigned int  TX_ID = 0x101;
#else
    const unsigned int  RX_ID = 0x101;
    const unsigned int  TX_ID = 0x100;
#endif

// ---------------------------------------------------------------------------------------
//* @brief   Prints CAN message to PC's serial terminal
void printMsg(CANMessage& msg, int dir)
{   if (dir ==0)
    {  //BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"Message sent    ", LEFT_MODE); 
         serial7.printf(" Can message sent ok\n");
         serial7.printf("ID = 0x%.3x Data=", msg.id);
         for(int i = 0; i < msg.len; i++)
        serial7.printf(" 0x%.2X", msg.data[i]);
        serial7.printf("\r\n");       
    }    
    else
    {  //BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"Message received", LEFT_MODE); 
    }
    pc.printf("  ID      = 0x%.3x\r\n", msg.id);
    pc.printf("  Type    = %d\r\n", msg.type);
    pc.printf("  Format  = %d\r\n", msg.format);
    pc.printf("  Length  = %d\r\n", msg.len);
    pc.printf("  Data    =");
    for(int i = 0; i < msg.len; i++)
        pc.printf(" 0x%.2X", msg.data[i]);
    pc.printf("\r\n");
    serial7.printf(" Can message received ok\n");
             serial7.printf("ID = 0x%.3x Data= ", msg.id);
         for(int i = 0; i < msg.len; i++)
        serial7.printf(" 0x%.2X", msg.data[i]);
        serial7.printf("\r\n");       

    sprintf((char*)text2, "ID: %d", msg.id);
    //BSP_LCD_DisplayStringAt(2, LINE(7), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Type: %d", msg.type);
    //BSP_LCD_DisplayStringAt(2, LINE(8), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Format: %d", msg.format);
    //BSP_LCD_DisplayStringAt(2, LINE(9), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Length: %d", msg.len);
    //BSP_LCD_DisplayStringAt(2, LINE(10), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Data: %d", msg.data[0]);
    //BSP_LCD_DisplayStringAt(2, LINE(11), (uint8_t *)&text2, LEFT_MODE);   
}

/** -----------------------------------------------------------------------------------------
 * @brief   Handles received CAN messages
 * @note    Called on 'CAN message received' interrupt.
 */
void onCanReceived(void)
{   can.read(rxMsg);
    pc.printf("-------------------------------------\r\n");
    pc.printf("CAN message received\r\n");
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Can msg rec", CENTER_MODE);
    printMsg(rxMsg,1);   
    serial7.printf("ID: 0x%.3x ", rxMsg.id);
    serial7.printf("D: ");
    for(int i = 0; i < rxMsg.len; i++)
        serial7.printf(" 0x%.2X", rxMsg.data[i]);
    serial7.printf("\r\n");   
    if (rxMsg.id == RX_ID) {
        // extract data from the received CAN message 
        // in the same order as it was added on the transmitter side
        rxMsg >> counter;
        rxMsg >> voltage;    
        pc.printf("  counter = %d\r\n", counter);
        pc.printf("  voltage = %e V\r\n", voltage);
    }
    timer.start(); // to transmit next message in main
}
// ---------------------------------------------------
void pc_recv()
{    if(serial7.readable()) 
    {   buffer[i]=(serial7.getc());
    if (buffer[i] == '\n') {
           serial7.printf("%s",buffer);
            len = 0;
            idx_ser =0;
            recv_ser = 1;
    }        
    idx_ser++;
    }
}

// ------------------------------------------------------------------------------------------
int main()
{   pc.baud(115200);
    //serial2.baud(115200);  // required for tasmota
    serial2.baud(57600);  // required for UDP bridge
    serial7.baud(115200);  // required for tasmota
    //serial7.attach(&pc_recv, Serial::RxIrq);
    
   // config can --------------------------------------
    can.frequency(125000); // set CAN bit rate to 125 kbps
    //can.filter(RX_ID, 0xFFF, CANStandard, 0); // set filter #0 to accept only standard messages with ID == RX_ID
  //--  can.attach(onCanReceived);                // attach ISR to handle received messages
#if defined(BOARD1)
    timer.start();          // start timer
    pc.printf("CAN_Hello board #1\r\n");
#else
    pc.printf("CAN_Hello board #2\r\n");
#endif
    buffer[0] = '\0';
    printf("\nInit SDCard ...\n");
    mainSDCardJPA() ;  // init SD - read  prog parameters from SD (from sdcardjpa.cpp in sdfilesystem_warning_fixed lib
    // reaf following datas
    // IP address, Ethernet actif, Wifi actif, Can actif, serial actif,fonction, buttons parameters
    // store local variables from sd
    //extern char gsStreamIPdatas[];
    //extern char ethernet_actif[] ;
    //extern char wifi_actif[];
    //extern char can_actif[];
    //extern char serial_actif[];
    printf("\nFin init SDCard ...\n");
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE);  // clear LCD
    uint8_t text[300];
    printf("Start Prog\n");    
    std::string temp1;
    std::string temp2;
    
    //lastSuccessfulUploadTime is used for upload frequency.
    time_t lastSuccessfulUploadTime = 0;    
    printf("\n Init touchJPA1 ...\n");
    int yy;
    printf("\n Init initDisplayTemp ...\n"); 
    yy = initDisplayTemp();   // from guijpa.cpp - Init display
    printf("\ninit touchInitJPA1 ...\n");
    yy = touchInitJPA1();  // from touchscreen.cpp - init touchscreen
    yy = touchInitGuiJPA1();  // from touchscreen.cpp 
    printf("\ninit initDatasGuiJPA ...\n");
    yy = initDatasGuiJPA();  // from guijpa.cpp - config buttons             
    ////lcd.printf("Starting...");
    printf("Starting...\n");
    lastToucheTime = time(NULL);
     char data[5];
     // main loop ---------------------------------------------------
    while (true) {
        // lecture sur port serie from tasmota
    if(serial7.readable()) 
    {   buffer[i]=(serial7.getc());
        serial7.printf("%c",buffer[i]);
        if (buffer[i] == '\n') {
           serial7.printf("%s",buffer);
            len = 0;
            idx_ser =0;
            recv_ser = 1;
        }        
        idx_ser++;
     }
      if ( recv_ser == 1)
      {serial7.printf("sent: %s",buffer);
      pc.printf("sent: %s",buffer);
      recv_ser =0;
      }
               
        // timer send can 
       if(timer.read_ms() >= 1000)            // check for timeout
       {    timer.stop();                       // stop the timer
            timer.reset();                      // reset the timer
            counter++;                          // increment the counter
            voltage = (analogIn * 3.3f)/4096.0f;// read the small drifting voltage from analog input
            txMsg.clear();                      // clear the Tx message storage
            //txMsg.id = TX_ID;            // set ID
            txMsg.id = 0x18881001;//TX_ID;                   // set the message ID
            txMsg.format = CANExtended ; //extended
            // We are about to transmit two data items to the CAN bus.
            //     counter: uint_8 (unsigned eight bits int) value (one byte).
            //     voltage: floating point value (four bytes).
            // So the total length of payload data is five bytes.
            // We'll use the "<<" (append) operator to add data to the CAN message.
            // The usage is same as of the similar C++ io-stream operators.
            // NOTE: The data length of CAN message is automatically updated when using "<<" operators.  
            txMsg << counter << voltage;        // append data (total data length must be <= 8 bytes!)
            
            if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                //led = OFF;                      // turn the LED off
                pc.printf("-------------------------------------\r\n");
                pc.printf("CAN message sent\r\n");
                printMsg(txMsg,0);
                pc.printf("  counter = %d\r\n", counter);
                pc.printf("  voltage = %e V\r\n", voltage);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
            }
            else
            {    pc.printf("Transmission error\r\n");
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
            //timer.start();                  // insert transmission lag
        }  // end if timer
        //touch screen
        int xx = touchJPA1();  //
        if (xx > 0) 
        {  pc.printf("Touche appuyee %d \r\n",xx);
        // send data to serial bridge tasmota
           serial2.printf("  Touche %d appuyee to Tasmota", xx);  
           serial7.printf("  Touche %d appuyee to Tasmota", xx);  
           if (xx ==4 )
           { // send trame to can
           if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                //led = OFF;                      // turn the LED off
                pc.printf("-------------------------------------\r\n");
                pc.printf("CAN message sent\r\n");
                printMsg(txMsg,0);
                pc.printf("  counter = %d\r\n", counter);
                pc.printf("  voltage = %e V\r\n", voltage);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
                serial7.printf(" send trame can ok");
            }
            else
            {    pc.printf("Transmission error\r\n");
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
           }    
           pc.printf("data sent to tasmota serial bridge \n");
           // data sent to ethernet
           xx = sendTouchJPA(xx);  
            
           lastToucheTime = time(NULL);
           
        } 
        else 
        {  lastToucheTime = 0;
        }   // send mqtt
        // Update sensor data to GroveStreams
        seconds = time(NULL);
        if(seconds - lastSuccessfulUploadTime > updateFrequency) {
            ////lcd.clear();            
            ////lcd.printf("Getting Samples...");
            printf("Getting Samples...\n");          
            //Assemble the samples into URL parameters which are seperated with the "&" character
            // Example: &s1=6.2&s2=78.231
            int temperature = adc_temp.read() * 100.0f;
            int voltage = adc_vref.read() * 100.0f;
            char samples[64] = {0};
            sprintf(samples, "&%s=%d&%s=%d", gsStreamId1, voltage, gsStreamId2, temperature);           
            //Append on command requests (request stream values)
            //This will indicate to GroveStreams to return the last value
            // of each request stream during the sample upload
            strcat(samples, "&rsid=freq&rsid=led");            
            char resultBuffer[700]= {0};
            //Sending Samples (and returning current command stream values)
            time_t connectAttemptTime = time(NULL);
            int sendResult = groveStreams.send(myMac, samples, gsCompName, gsCompTmplId, resultBuffer, sizeof resultBuffer);  //receive mqtt
            
            if (sendResult == 0) {
                ////lcd.printf("Send Successful");
                printf("Send Successful\n");
                lastSuccessfulUploadTime = connectAttemptTime;               
                //Handle command streams
                if (strlen(resultBuffer) > 0 && resultBuffer[0] == '{') {
                    MbedJSONValue mbedJson;
                    parse(mbedJson, resultBuffer);                    
                    sprintf((char*)text, "HTTP string : %s\n", resultBuffer);
                    //BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);                
                    if (mbedJson.hasMember("Temp1")) {
                        int pp=setTemp1(mbedJson["Temp1"].get<std::string>());
                    }
                    if (mbedJson.hasMember("Temp2")) {
                        int tt=setTemp2(mbedJson["Temp2"].get<std::string>());
                    }
                    if (mbedJson.hasMember("led")) {
                        //Change LED
                        myled = mbedJson["led"].get<bool>() ? 1 : 0;
                        ////lcd.printf("LED: %s", mbedJson["led"].get<bool>() ? "On" : "Off");
                        printf("LED: %s\n", mbedJson["led"].get<bool>() ? "On" : "Off");
                    }
                }
            } 
        }
        
    }
}


