#include "mbed.h"

const int        kMaxBufferSize = 125;

volatile char    bufferSerialUSB[kMaxBufferSize+3];
volatile int     idxSerialIntUSB = 0;
int              idxSerialUserUSB = 0;
volatile int     msgSerialUSB = 0;
char             stringSerialUSB[kMaxBufferSize+3];
int              stringSerialUSBok = 0;               // si ==1 alors trame dispo (fin de trame == LF ou 10
int              idxSerialStringUSB = 0;

volatile char    bufferSerial2[kMaxBufferSize+3];
volatile int     idxSerialInt2 = 0;
int              idxSerialUser2 = 0;
volatile int     msgSerial2 = 0;
char             stringSerial2[kMaxBufferSize+3];
int              stringSerial2ok = 0;                 // si ==1 alors trame dispo (fin de trame == LF ou 10
int              idxSerialString2 = 0;

volatile char    bufferSerial7[kMaxBufferSize+3];
volatile int     idxSerialInt7 = 0;
int              idxSerialUser7 = 0;
volatile int     msgSerial7 = 0;
char             stringSerial7[kMaxBufferSize+3];
int              stringSerial7ok = 0;                 // si ==1 alors trame dispo (fin de trame == LF ou 10
int              idxSerialString7 = 0;

//RawSerial
RawSerial          serialUSB(USBTX, USBRX);    // serial PC
RawSerial          serial2(PC_6, PC_7); // TX, RX for udp bridge
RawSerial          serial7(PF_7, PF_6); // TX, RX for extension
// ---------------------------------------------------
void serialUSB_int_recv()
    {       
    if(serialUSB.readable()) 
        {   
        bufferSerialUSB[idxSerialIntUSB]=(serialUSB.getc());
        idxSerialIntUSB++;
        if (idxSerialIntUSB >= kMaxBufferSize) {idxSerialIntUSB = 0;}
        bufferSerialUSB[idxSerialIntUSB]= 0;
        msgSerialUSB = 1;
        }
    return;
    }
// ---------------------------------------------------------------------------
void serial2_int_recv()
    {       
    if(serial2.readable()) 
        {   
        bufferSerial2[idxSerialInt2]=(serial2.getc());
        idxSerialInt2++;
        if (idxSerialInt2 >= kMaxBufferSize) {idxSerialInt2 = 0;}
        bufferSerial2[idxSerialInt2]= 0;
        msgSerial2 = 1;
        }
    return;
    }
// ----------------------------------------------------------------------------
void serial7_int_recv()
    {       
    if(serial7.readable()) 
        {           
        bufferSerial7[idxSerialInt7]=(serial7.getc());
        //printf("%c",bufferSerial7[idxSerialInt7]);
        idxSerialInt7++;
        if (idxSerialInt7 >= kMaxBufferSize) {idxSerialInt7 = 0;}
        bufferSerial7[idxSerialInt7]= 0;
        msgSerial7 = 1;
        }
    return;
    }   
// --------------------------------------------------------------------------------   
void initSerial()
    {
    serialUSB.baud(115200);
    serialUSB.attach(&serialUSB_int_recv, Serial::RxIrq);
    serial2.baud(115200);  // required for Tasmota
    //serial2.baud(57600);  // required for UDP bridge
    serial2.attach(&serial2_int_recv, Serial::RxIrq);
    serial7.baud(115200);  // required for tasmota
    serial7.attach(&serial7_int_recv, Serial::RxIrq);    
    bufferSerialUSB[0] = '\0';
    bufferSerial2[0] = '\0';
    bufferSerial7[0] = '\0';   
    }
// ---------------------------------------------------------------------------      
void sendSerialUSB(char * str)
    {
    serialUSB.printf(str);
    }
// ---------------------------------------------------------------------------    
void receiveSerialUSB()
    {
    char x;
    if (stringSerialUSBok == 0)     // string user dispo flag a mettre a 0 par user a chaque lecture de string
        {
        while(idxSerialIntUSB != idxSerialUserUSB)
            {
            x=bufferSerialUSB[idxSerialUserUSB];
            //printf("%c",x);  
            idxSerialUserUSB = idxSerialUserUSB + 1;
            if (idxSerialUserUSB >= kMaxBufferSize) {idxSerialUserUSB = 0;} 
            
            stringSerialUSB[idxSerialStringUSB] = x;
            idxSerialStringUSB = idxSerialStringUSB + 1;stringSerialUSB[idxSerialStringUSB] = 0;
            if (idxSerialStringUSB >= kMaxBufferSize) 
                {stringSerialUSB[idxSerialStringUSB-1] = 10;idxSerialStringUSB = 0;stringSerialUSBok = 1;}
            if (x == 10) {idxSerialStringUSB = 0;stringSerialUSBok = 1;}
            }
        msgSerialUSB = 0;
        }
    }
// ------------------------------------------------------------------------------    
void sendSerial2(char * str)
    {
    serial2.printf(str);
    }
// ------------------------------------------------------------------------------    
void receiveSerial2()
    {
    char x;
    if (stringSerial2ok == 0)     // string user dispo flag a mettre a 0 par user a chaque lecture de string
        {
        while(idxSerialInt2 != idxSerialUser2)
            {
            x=bufferSerial2[idxSerialUser2];
            //printf("%c",x);  
            idxSerialUser2 = idxSerialUser2 + 1;
            if (idxSerialUser2 >= kMaxBufferSize) {idxSerialUser2 = 0;} 
            
            stringSerial2[idxSerialString2] = x;
            idxSerialString2 = idxSerialString2 + 1;stringSerial2[idxSerialString2] = 0;
            if (idxSerialString2 >= kMaxBufferSize) 
                {stringSerial2[idxSerialString2-1] = 10;idxSerialString2 = 0;stringSerial2ok = 1;}
            if (x == 10) {idxSerialString2 = 0;stringSerial2ok = 1;}
            }
        msgSerial2 = 0;
        }
    }
// --------------------------------------------------------------------------------       
void sendSerial7(char * str)
    {
    serial7.printf(str);
    }
// -------------------------------------------------------------------------------    
void receiveSerial7()
    {
    char x;
    if (stringSerial7 == 0)     // string user dispo flag a mettre a 0 par user a chaque lecture de string
        {
        while(idxSerialInt7 != idxSerialUser7)
            {
            x=bufferSerial7[idxSerialUser7];
            //printf("%c",x);  
            idxSerialUser7 = idxSerialUser7 + 1;
            if (idxSerialUser7 >= kMaxBufferSize) {idxSerialUser7 = 0;} 
            
            stringSerial7[idxSerialString7] = x;
            idxSerialString7 = idxSerialString7 + 1;stringSerial2[idxSerialString7] = 0;
            if (idxSerialString7 >= kMaxBufferSize) 
                {stringSerial7[idxSerialString7-1] = 10;idxSerialString7 = 0;stringSerial7ok = 1;}
            if (x == 10) {idxSerialString7 = 0;stringSerial7ok = 1;}
            }
        //msgSerial2 = 0;
        msgSerial7 = 0;
        }
    }