#include "SD_Helper.h"
#include "stm32746g_discovery_sd.h"

#define _CCSIDR_LSSHIFT(x)  (((x) & SCB_CCSIDR_LINESIZE_Msk) >> SCB_CCSIDR_LINESIZE_Pos)

static SD_HandleTypeDef uSdHandle;
static int RX_Busy;
static int TX_Busy;
static int SD_Busy;



/* cache flush */
void CPU_CACHE_Flush(uint32_t * buffer, uint32_t length)
{
 // SCB_InvalidateDCache_by_Addr(buffer,length);
  uint32_t ccsidr;
  uint32_t smask;
  uint32_t sshift;
  uint32_t ways;
  uint32_t wshift;
  uint32_t ssize;
  uint32_t sets;
  uint32_t sw;
  uint32_t start;
  uint32_t ende;

  start=(uint32_t)buffer;
  ende=start+length;
  /* Get the characteristics of the D-Cache */

  ccsidr = SCB->CCSIDR;
  smask  = CCSIDR_SETS(ccsidr);          /* (Number of sets) - 1 */
  sshift = _CCSIDR_LSSHIFT(ccsidr) + 4;   /* log2(cache-line-size-in-bytes) */
  ways   = CCSIDR_WAYS(ccsidr);          /* (Number of ways) - 1 */

  /* Calculate the bit offset for the way field in the DCCISW register by
   * counting the number of leading zeroes.  For example:
   *
   *   Number of  Value of ways  Field
   *   Ways       'ways'         Offset
   *     2         1             31
   *     4         3             30
   *     8         7             29
   *   ...
   */

  wshift = __CLZ(ways) & 0x1f;

  /* Clean and invalidate the D-Cache over the range of addresses */

  ssize  = (1 << sshift);
  start &= ~(ssize - 1);
  __DSB();

  do
    {
      int32_t tmpways = ways;

      /* Isolate the cache line associated with this address.  For example
       * if the cache line size is 32 bytes and the cache size is 16KB, then
       *
       *   sshift = 5      : Offset to the beginning of the set field
       *   smask  = 0x007f : Mask of the set field
       */

      sets = ((uint32_t)start >> sshift) & smask;

      /* Clean and invalidate each way for this cacheline */

      do
        {
          sw = ((tmpways << wshift) | (sets << sshift));
          SCB->DCCISW=sw;

        }
      while (tmpways--);

      /* Increment the address by the size of one cache line. */

      start += ssize;
    }
  while (start < ende);

  __DSB();
  __ISB();
}

void BSP_SD_CommandTransaction(char cmd, unsigned int arg)
{
  SDMMC_CmdInitTypeDef sdmmc_cmdinitstructure;
  uSdHandle.Instance = SDMMC1;
  sdmmc_cmdinitstructure.Argument         = (uint32_t)arg;
  sdmmc_cmdinitstructure.CmdIndex         = cmd;
  sdmmc_cmdinitstructure.Response         = SDMMC_RESPONSE_SHORT;
  sdmmc_cmdinitstructure.WaitForInterrupt = SDMMC_WAIT_NO;
  sdmmc_cmdinitstructure.CPSM             = SDMMC_CPSM_ENABLE;
  SDMMC_SendCommand(uSdHandle.Instance, &sdmmc_cmdinitstructure);
}

void BSP_SD_Set_Busy(void)
{
    SD_Busy=1;
}
void BSP_SD_Clear_Busy(void)
{
    SD_Busy=0;
}
int BSP_SD_Get_Busy(void)
{
    return SD_Busy;
}

void BSP_SD_Set_RX_Busy(void)
{
    RX_Busy=1;
}
void BSP_SD_Clear_RX_Busy(void)
{
    RX_Busy=0;
}
int BSP_SD_Get_RX_Busy(void)
{
    return RX_Busy;
}

void BSP_SD_Set_TX_Busy(void)
{
    TX_Busy=1;
}
void BSP_SD_Clear_TX_Busy(void)
{
    TX_Busy=0;
}
int BSP_SD_Get_TX_Busy(void)
{
    return TX_Busy;
}
