/*
 License:
  Copyright (C) 2017 GroveStreams LLC.
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at: http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
 
#include "LcdDiscoF746NgTracer.h"


LcdDiscoF746NgTracer::LcdDiscoF746NgTracer()
{
    _line = 0;
    _maxLines = 21;
    _lcd.Clear(LCD_COLOR_BLACK);
    _lcd.SetBackColor(LCD_COLOR_BLACK);
    _lcd.SetTextColor(LCD_COLOR_WHITE);
    _lcd.SetFont(&Font12);
}

void LcdDiscoF746NgTracer::printf(const char* format, ...)
{
    char sbuffer[512] = {0};

    va_list args;
    va_start(args, format);
    vsprintf(sbuffer, format, args);

    this->println(sbuffer);

    va_end(args);
}

void LcdDiscoF746NgTracer::println(const char* sbuffer)
{

    //LCD can only disply 60 chars at a time
    int ichar = 0;
    int charCount = strlen(sbuffer);
    while (charCount>0) {
    
        char subbuff[61] = {0}; //Initialize buffer to nulls
        if (charCount < 60) {
            memcpy( subbuff, &sbuffer[ichar], charCount);
            charCount=0;
        } else {
            memcpy( subbuff, &sbuffer[ichar], 60);
            charCount -= 60;
        }
        
        _lcd.DisplayStringAtLine(_line, (uint8_t *)subbuff);
        
        _line++;
         if (_line == _maxLines) {
             clear();
        }
        
        ichar+=60;
    }
}

void LcdDiscoF746NgTracer::clear()
{
    _line = 0;
    _lcd.Clear(LCD_COLOR_BLACK);
}



