/*
programme test  sur carte stm32F746ng-discovery

update 30/07/2019 : display datas on lcd ok
update 29/07/2020 : send can ok ( after received), receive can ok
update 29/07/2020 : remove touch screen
update 28/07/2020 : add serial and CAN
update 21/07/2020 : test buttons
update 20/07/2020 : display buttons
update 17/07/2020 GC : change colors
*/

#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include <string> 
#include "CANMsg.h"
#include <stdio.h>
#include <errno.h>

// serial port sur connecteur arduino (D0,D1)--------------------
Serial    serial2(PC_6, PC_7); // TX, RX for udp bridge
Serial    pc(USBTX, USBRX);  // serial on usb connector
// CAN ------------------------------------------------------------
CAN        can(PB_8, PB_9);  // CAN Rx pin name, CAN Tx pin name
CANMsg     rxMsg;
CANMsg     txMsg;

uint8_t             counter = 0;
float               voltage;
Timer               timer;
volatile bool   msgAvailable = false;
AnalogIn        analogIn(A0);
CircularBuffer<char, 1024> rxbuf;    // PC receiving Buffer
uint8_t text2[30];
  char s2;
  char buffer[128];
#define LED_PIN     PC_13
DigitalOut          led(LED_PIN);

//#define TARGET_STM32F103C8T6    1       // uncomment this line to use STM32F103C8T6 boards
#define BOARD1                  1       // comment out this line when compiling for board #2
#if defined(BOARD1)
    const unsigned int  RX_ID = 0x100;
    const unsigned int  TX_ID = 0x101;
#else
    const unsigned int  RX_ID = 0x101;
    const unsigned int  TX_ID = 0x100;
#endif

/**
 * @brief   Prints CAN message to PC's serial terminal
 * @param   CANMessage to print
 */
void printMsg(CANMessage& msg, int dir)
{   if (dir ==0)
    {  BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"Message sent    ", LEFT_MODE); 
    }    
    else
    {  BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"Message received", LEFT_MODE); 
    }
    pc.printf("  ID      = 0x%.3x\r\n", msg.id);
    pc.printf("  Type    = %d\r\n", msg.type);
    pc.printf("  Format  = %d\r\n", msg.format);
    pc.printf("  Length  = %d\r\n", msg.len);
    pc.printf("  Data    =");
    for(int i = 0; i < msg.len; i++)
        pc.printf(" 0x%.2X", msg.data[i]);
    pc.printf("\r\n");
    
    sprintf((char*)text2, "ID: %d", msg.id);
    BSP_LCD_DisplayStringAt(2, LINE(7), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Type: %d", msg.type);
    BSP_LCD_DisplayStringAt(2, LINE(8), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Format: %d", msg.format);
    BSP_LCD_DisplayStringAt(2, LINE(9), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Length: %d", msg.len);
    BSP_LCD_DisplayStringAt(2, LINE(10), (uint8_t *)&text2, LEFT_MODE);
    sprintf((char*)text2, "Data: %d", msg.data[0]);
    BSP_LCD_DisplayStringAt(2, LINE(11), (uint8_t *)&text2, LEFT_MODE);   
}

/**
 * @brief   Handles received CAN messages
 * @note    Called on 'CAN message received' interrupt.
 */
void onCanReceived(void)
{   can.read(rxMsg);
    pc.printf("-------------------------------------\r\n");
    pc.printf("CAN message received\r\n");
    serial2.printf("CAN message received\r\n");
    BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Can msg rec", CENTER_MODE);
    //BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
    printMsg(rxMsg,1);   
    //serial2.printf("%d\n",rxMsg); 
    //serial2.printf("ID: ");
    serial2.printf("ID: 0x%.3x ", rxMsg.id);
    serial2.printf("D: ");
    for(int i = 0; i < rxMsg.len; i++)
        serial2.printf(" 0x%.2X", rxMsg.data[i]);
    serial2.printf("\r\n");   
    if (rxMsg.id == RX_ID) {
        // extract data from the received CAN message 
        // in the same order as it was added on the transmitter side
        rxMsg >> counter;
        rxMsg >> voltage;    
        pc.printf("  counter = %d\r\n", counter);
        pc.printf("  voltage = %e V\r\n", voltage);
    }
    timer.start(); // to transmit next message in main
}
 
 // ------------------------------------------------------------------------------------------------------
int main()
{   TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t menu_level = 0;
    uint8_t prev_nb_touches = 0;
    uint8_t touche_appuyee = 99;
    string touche_appuyee_s = "%";
    string  text_display1 ("Memorisation Touches ");
    char buffer_touche[50];
    // set serial speed
    pc.baud(57600);
    serial2.baud(57600);
    // config can --------------------------------------
    //jpa can = new CAN(PB_8, PB_9);        // CAN Rx pin name, CAN Tx pin name
    can.frequency(125000); // set CAN bit rate to 125 kbps
    //can.filter(RX_ID, 0xFFF, CANStandard, 0); // set filter #0 to accept only standard messages with ID == RX_ID
    can.attach(onCanReceived);                // attach ISR to handle received messages
    //can->attach(&onMsgReceived);   //msgAvailable = true;     // attach the 'CAN receive-complete' interrupt service routine (ISR) 
#if defined(BOARD1)
    timer.start();          // start timer
    pc.printf("CAN_Hello board #1\r\n");
#else
    pc.printf("CAN_Hello board #2\r\n");
#endif
    pc.printf("\nStart Prog\n");
    serial2.printf("\nStart Prog\n");
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    //BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    //HAL_Delay(1000);
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        BSP_LCD_Clear(LCD_COLOR_BLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    pc.printf("\nInit Display\n");
     HAL_Delay(1000);       
     BSP_LCD_Clear(LCD_COLOR_BLUE);
     BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
     BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
     BSP_LCD_DisplayStringAt(0, LINE(2), (uint8_t *)"STM32F746 Disco Appli", CENTER_MODE);
     BSP_LCD_SetTextColor(LCD_COLOR_RED);
     BSP_LCD_DrawRect(10, 100, 200, 50);
     BSP_LCD_DrawRect(10, 180, 200, 50);
     BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
     BSP_LCD_DisplayStringAt(25, LINE(5), (uint8_t *)"Setup", LEFT_MODE);
     BSP_LCD_DisplayStringAt(25, 200, (uint8_t *)"Run", LEFT_MODE);
     BSP_LCD_SetFont(&Font12);
 
        BSP_LCD_Clear(LCD_COLOR_BLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_SetFont(&Font16);
        BSP_LCD_DisplayStringAt(0, LINE(2), (uint8_t *)"Mode Run", CENTER_MODE);
   
                      
    //HAL_Delay(1000);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);

    while(1) //menu_level == 1)       
    {  // timer send can 
       if(timer.read_ms() >= 1000)            // check for timeout
       {    timer.stop();                       // stop the timer
            timer.reset();                      // reset the timer
            counter++;                          // increment the counter
            voltage = (analogIn * 3.3f)/4096.0f;// read the small drifting voltage from analog input
            txMsg.clear();                      // clear the Tx message storage
            //txMsg.id = TX_ID;            // set ID
            txMsg.id = 0x18881001;//TX_ID;                   // set the message ID
            txMsg.format = CANExtended ; //extended
            // We are about to transmit two data items to the CAN bus.
            //     counter: uint_8 (unsigned eight bits int) value (one byte).
            //     voltage: floating point value (four bytes).
            // So the total length of payload data is five bytes.
            // We'll use the "<<" (append) operator to add data to the CAN message.
            // The usage is same as of the similar C++ io-stream operators.
            // NOTE: The data length of CAN message is automatically updated when using "<<" operators.  
            txMsg << counter << voltage;        // append data (total data length must be <= 8 bytes!)
            
            if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                //led = OFF;                      // turn the LED off
                pc.printf("-------------------------------------\r\n");
                pc.printf("CAN message sent\r\n");
                printMsg(txMsg,0);
                pc.printf("  counter = %d\r\n", counter);
                pc.printf("  voltage = %e V\r\n", voltage);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
            }
            else
            {    pc.printf("Transmission error\r\n");
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
            //timer.start();                  // insert transmission lag
        }  // end if timer
        // read can
        if (can.read(rxMsg));
        {
    pc.printf("-------------------------------------\r\n");
    pc.printf("CAN message received\r\n");
    serial2.printf("CAN message received\r\n");
    
    printMsg(rxMsg,1);   
    serial2.printf("%d\n",rxMsg); 
    serial2.printf("ID: ");
    serial2.printf("ID: 0x%.3x ", rxMsg.id);
    serial2.printf("D: ");
    for(int i = 0; i < rxMsg.len; i++)
        serial2.printf(" 0x%.2X", rxMsg.data[i]);
    serial2.printf("\r\n");   
    }
        
        
        
       // read serial port
       // get serial 2      
       //serial2.gets(buffer, 4); 
       //pc.printf("I got '%s'\n", buffer);
        char c = pc.getc();
        
        if((c == 's') ) 
        {   // send trame  CAN
           if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                //led = OFF;                      // turn the LED off
                pc.printf("-------------------------------------\r\n");
                pc.printf("CAN message sent\r\n");
                printMsg(txMsg,0);
                pc.printf("  counter = %d\r\n", counter);
                pc.printf("  voltage = %e V\r\n", voltage);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
            }
            else
            {    pc.printf("Transmission error\r\n");
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
         } 
         
        char ser2 = serial2.getc();
        if( (ser2 = 's') ) 
        {   // send trame  CAN
           if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                //led = OFF;                      // turn the LED off
                pc.printf("-------------------------------------\r\n");
                pc.printf("CAN message sent\r\n");
                printMsg(txMsg,0);
                pc.printf("  counter = %d\r\n", counter);
                pc.printf("  voltage = %e V\r\n", voltage);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
            }
            else
            {    pc.printf("Transmission error\r\n");
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
         } 
         
       // gestion touches appuyees
       BSP_TS_GetState(&TS_State); 
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    BSP_LCD_ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;
            cleared = 0;
            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            BSP_LCD_DisplayStringAt(2, LINE(1), (uint8_t *)&text, LEFT_MODE);
            
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
            }
            BSP_LCD_DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
                      
            // rajouter test touche appuyée
            if ((y>100)& (y<150))
            {  // touches 0 a 5 appuyées
               if ((x>10)&(x<60))
               {  // touche 0 appuyée)
                  sprintf((char*)text, "Touche 0 appuyée");
                  BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                  touche_appuyee = 0;touche_appuyee_s = "0";
               }  
               if ((x>90)&(x<130))
               {  // touche 1 appuyée)
                  sprintf((char*)text, "Touche 1 appuyée");
                  BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                  touche_appuyee = 1;touche_appuyee_s = "1";
               } 
               if ((x>180)&(x<230))
               {  // touche 2 appuyée)
                  sprintf((char*)text, "Touche 2 appuyée");
                  BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                  touche_appuyee = 2;touche_appuyee_s = "2";
               } 
               if ((x>260)&(x<310))
               {  // touche 3 appuyée)
                  sprintf((char*)text, "Touche 3 appuyée");
                  BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                  touche_appuyee = 3;touche_appuyee_s = "3";
               } 
               if ((x>340)&(x<390))
               {  // touche 4 appuyée)
                  sprintf((char*)text, "Touche 4 appuyée");
                  BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                  touche_appuyee = 4;touche_appuyee_s = "4";
               } 
               if ((x>420)&(x<470))
               {  // touche 5 appuyée)
                  sprintf((char*)text, "Touche 5 appuyée");
                  BSP_LCD_DisplayStringAt(2, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
                  touche_appuyee = 5;touche_appuyee_s = "5";
               } 
               text_display1 = text_display1 + touche_appuyee_s; 
               sprintf(buffer_touche, "text_display1 %d", touche_appuyee);               
               BSP_LCD_DisplayStringAt(2, 3, (uint8_t *)&buffer_touche, LEFT_MODE);  
            } 
                
         } else {
            if (!cleared)
            {    //BSP_LCD_Clear(LCD_COLOR_BLUE);
             //   sprintf((char*)text, "Touches: 0");
            //    BSP_LCD_DisplayStringAt(2, LINE(2), (uint8_t *)&text, LEFT_MODE);
                cleared = 1;
            }
        }
     }                
}

//int main() {
//    pc.printf("Hello World!\n\r");
//    while(1) {
//        pc.putc(pc.getc() + 1); // echo input back to terminal
//    }//
//}
/*
int main() {
    while(1) {
        if(pc.readable()) {
            device.putc(pc.getc());
        }
        if(device.readable()) {
            pc.putc(device.getc());
        }
    }
}
*/
/*
#include "mbed.h"
 
Serial pc(USBTX, USBRX); // tx, rx
PwmOut led(LED1);
 
float brightness = 0.0;
 
int main() {
    pc.printf("Press 'u' to turn LED1 brightness up, 'd' to turn it down\n");
 
    while(1) {
        char c = pc.getc();
        if((c == 'u') && (brightness < 0.5)) {
            brightness += 0.01;
            led = brightness;
        }
        if((c == 'd') && (brightness > 0.0)) {
            brightness -= 0.01;
            led = brightness;
        } 
 
    }
}
*/
/*
#include "mbed.h"
 
Serial pc(USBTX, USBRX);
Serial uart(p28, p27);
 
DigitalOut pc_activity(LED1);
DigitalOut uart_activity(LED2);
 
int main() {
    while(1) {
        if(pc.readable()) {
            uart.putc(pc.getc());
            pc_activity = !pc_activity;
        }
        if(uart.readable()) {
            pc.putc(uart.getc());
            uart_activity = !uart_activity;
        }
    }
}
*/
/*
#include "mbed.h"
 
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
 
int main() {
    char c;
    char buffer[128];
        
    pc.gets(buffer, 4);
 
    pc.printf("I got '%s'\n", buffer);    
}
*/
/*
sd card filesystem
/* Example file of using SD/MMC Block device Library for MBED-OS
 * Copyright 2017 Roy Krikke
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 
#include "mbed.h"
#include "FATFileSystem.h"
#include "SDBlockDeviceDISCOF746NG.h"
#include <stdio.h>
#include <errno.h>
 
DigitalOut led (LED1);
 
// Instantiate the Block Device for sd card on DISCO-F746NG
SDBlockDeviceDISCOF746NG bd;
FATFileSystem fs ("fs");
 
void
return_error (int ret_val)
{   if(ret_val)
        printf ("Failure. %d\r\n", ret_val);
    else
        printf ("done.\r\n");
}
 
void
errno_error (void* ret_val)
{  if(ret_val == NULL)
        printf (" Failure. %d \r\n", errno);
    else
        printf (" done.\r\n");
}
 
int
main ()
{
    Serial pc (SERIAL_TX, SERIAL_RX);
    pc.baud(115200);
    printf("Start\n");
 
    int error = 0;
    printf("Welcome to the filesystem example.\r\n"
           "Formatting a FAT, RAM-backed filesystem. ");
    error = FATFileSystem::format(&bd);
    return_error(error);
 
    printf("Mounting the filesystem on \"/fs\". ");
    error = fs.mount(&bd);
    return_error(error);
 
    printf("Opening a new file, numbers.txt.");
    FILE* fd = fopen("/fs/numbers.txt", "w");
    errno_error(fd);
 
    for (int i = 0; i < 20; i++) {
        printf("Writing decimal numbers to a file (%d/20)\r", i);
        fprintf(fd, "%d\r\n", i);
    }
    printf("Writing decimal numbers to a file (20/20) done.\r\n");
 
    printf("Closing file.");
    fclose(fd);
    printf(" done.\r\n");
 
    printf("Re-opening file read-only.");
    fd = fopen("/fs/numbers.txt", "r");
    errno_error(fd);
 
    printf("Dumping file to screen.\r\n");
    char buff[16] = { 0 };
    while(!feof (fd)) {
        int size = fread(&buff[0], 1, 15, fd);
        fwrite(&buff[0], 1, size, stdout);
    }
    printf("EOF.\r\n");
 
    printf("Closing file.");
    fclose(fd);
    printf(" done.\r\n");
 
    printf("Opening root directory.");
    DIR* dir = opendir("/fs/");
    errno_error(fd);
 
    struct dirent* de;
    printf("Printing all filenames:\r\n");
    while((de = readdir (dir)) != NULL) {
        printf("  %s\r\n", &(de->d_name)[0]);
    }
 
    printf("Closeing root directory. ");
    error = closedir(dir);
    return_error(error);
    printf("Filesystem Demo complete.\r\n");
 
    // Blink led with 2 Hz
    while(true) {
        led = !led;
        wait (0.5);
    }
}
 */