#include"mbed.h"
#include"DS1820.h"
#include"DHT.h"
#include "TCS34725.h"
#include "Sigfox.h"
#include "WakeUp.h"
#include <math.h>

#define GROVE_MOIST_MIN     0
#define GROVE_MOIST_MAX     0.55
#define LOG_RANGE           5.0f

float Temp_Sol;
float Temp_Air;
float Humi_Air;
float Humi_Sol;
float Lumiere;
uint16_t r;
uint16_t g;
uint16_t b;
uint16_t c;

DHT dht22(D6,DHT22);//pin,type
DS1820  ds1820(A0);//pin
TCS34725 tcs34725(D4,D5); //I2C sda and scl
AnalogIn humigrove(A1);
AnalogIn lumiere(A5);
AnalogIn bat(A4);
DigitalOut ledTest(LED1);
DigitalOut mos(D9);

void ReadTempHumiAir(){
  int err=1;
  while(err!=0){
    err=dht22.readData();
    //ledTest = 1;
    wait(1);
   }
  if(err==0){
     Temp_Air= dht22.ReadTemperature(CELCIUS);
     Humi_Air=dht22.ReadHumidity();
     //ledTest = 0;
     }

 }
 
void ReadTempSol(){
  if (ds1820.begin()) {
        ds1820.startConversion();   // start temperature conversion from analog to digital
        wait(1);                  // let DS1820 complete the temperature conversion
        Temp_Sol = ds1820.read(); 
   }
}  

void ReadRGBC(){
    if(tcs34725.init(TCS34725_INTEGRATIONTIME_101MS, TCS34725_GAIN_60X)){
         tcs34725.getColor(r,g,b,c);
         r/=256;
         g/=256;
         b/=256;
         c/=256;
    }
}

void ReadHumiSol(){
    float grove_moist=humigrove.read();
    Humi_Sol= ((grove_moist-GROVE_MOIST_MIN) / (GROVE_MOIST_MAX - GROVE_MOIST_MIN)) * 100;
}

void ReadLumi(){
    float raw=lumiere.read();
    float loglux=raw*LOG_RANGE;
    Lumiere=(float)(pow(10,loglux)*255.0f)/10000;
    //Lumiere=loglux;
}

int main(){
    //Serial at(D1,D0);
    Sigfox sigfox(D1,D0);
    /*ledTest = 1;
    wait(20);
    ledTest = 0;
    wait(5);*/
    WakeUp::calibrate();
    //wait(30);
    
    while(1){
        WakeUp::set(120);
        mos = 0;
        sigfox.wake();
        wait(2);
        ReadTempHumiAir();
        ReadTempSol();
        ReadRGBC();
        ReadHumiSol();
        wait(1); 
        ReadLumi();
        wait(1);               
        printf("R:%d, G:%d, B:%d\n\r", r, g, b);  
        sigfox.send((s16)(Temp_Air*10),(u16)(Humi_Air*10),(s16)(Temp_Sol*10),(u16)(Humi_Sol*10),
            (u8)Lumiere,(u8)r,(u8)g,(u8)b, (u8)((float)bat*255.0f));
        wait(10);
        mos = 1;
        //wait(10);
        sigfox.sleep();
        deepsleep();
    }
}
