#ifndef NOTE_H
#define NOTE_H

typedef enum hit {
    drum_1 = 0,//バスドラム
    drum_2 = 1,//スネアドラム_1
    drum_2_1 = 2,//スネアドラム_2
    drum_3 = 3,//ロータム
    drum_4 = 4,//ハイタム
    drum_5 = 5,//フロアタム_1
    drum_5_1 = 6,//フロアタム_2
    cymbal_1 = 7,//ハイハット_1
    cymbal_1_1 = 8,//ハイハット_2
    cymbal_2  = 9,//クラッシュシンバル_low
    cymbal_3 = 10,//クラッシュシンバル_hight
    cymbal_4 = 11, //ライドシンバル
    hihat_off = 12,//ハイハットclose
    hihat_middle = 13,//ハイハットmiddle
    rest
} hit_t;
 
typedef struct {
    hit_t hit;
    double time;
} note_t;

 
 
 
double bpm_1=170;
double note_4=60000000.0/bpm_1;//四分音符
double note_2=note_4*2.0;//二分音符
double note_8=note_4/2.0;//八分音符
double note_16=note_8/2.0;//十六分音符
double onemeasure=4.0*note_4;
 
double bpm_2=104;
double note_4_2=60000000.0/bpm_2;//四分音符
double note_2_2=note_4_2*2.0;//二分音符
double note_8_2=note_4_2/2.0;//八分音符
double note_16_2=note_8_2/2.0;//十六分音符
double note_32_2=note_16_2/2.0;//三十二分音符
double onemeasure_2=4.0*note_4_2; 
 
 
#endif