#include <mbed.h>
#include "astronomical_observation.h"
#include "mugamutyu.h"
#include "tapeled.h"
#include "scrp_slave.hpp"

ScrpSlave slave(PC_12, PD_2, PH_1, SERIAL_TX, SERIAL_RX, 0x0807f801);

bool on_off;
bool led;
bool led_flag[12];

Timeout stop_0;
Timeout stop_1;
Timeout stop_2;
Timeout stop_3;
Timeout stop_4;
Timeout stop_5;
Timeout stop_6;
Timeout stop_7;
Timeout stop_8;
Timeout stop_9;//drum_2_1
Timeout stop_10;//drum_5_1
Timeout stop_11;//cymbal_1_1
Timeout stop_12;//haihat_close
Timeout stop_13;//haihat_middle

Timeout drum_1_stop;


Timer timekeeper;
Timer timekeeper_1;

Timer d1;

void checkpoint();
void checkpoint1();
void checkpoint2();
void checkpoint1_2();

DigitalOut led_pin[4] = {
    DigitalOut(PA_10),
    DigitalOut(PB_15),
    DigitalOut(PB_2),
    DigitalOut(PC_6)
};

DigitalOut solenoid[14] = {
    DigitalOut(PA_14),//バスドラム
    DigitalOut(PB_6),//スネアドラム_1
    DigitalOut(PB_7),//スネアドラム_2
    DigitalOut(PA_9),//ロータム
    DigitalOut(PA_1),//ハイタム
    DigitalOut(PC_3),//フロアタム_1
    DigitalOut(PC_2),//フロアタム_2
    DigitalOut(PB_4),//ハイハット_1
    DigitalOut(PB_5),//ハイハット_2
    DigitalOut(PA_0),//クラッシュシンバル_low
    DigitalOut(PC_0),//クラッシュシンバル_hight
    DigitalOut(PC_1),//ライドシンバル
    DigitalOut(PA_13),//ハイハットclosse
    DigitalOut(PC_4)//ハイハット//middle
};

PwmOut motor_pin[1][2]= {
    {PwmOut(PA_11),PwmOut(PB_1)}
};

InterruptIn limit_switch(PB_0,PullUp);

void (*func[12])();

int status;
int prev_status;

 
bool pause(int rx_data, int &tx_data){
    tx_data = rx_data;
    if(tx_data == 0){
        status = 0;
    }
    return true;
}

bool setup(int rx_data, int &tx_data){
    tx_data=rx_data;
    status=99;
    return true;
}

bool command0(int rx_data, int &tx_data ){
    tx_data = rx_data;
    switch(tx_data){
        case 1:
            status =1;
            break;
        case 2:
            status =2;
            break;
        case 3:
            status =3;
            break;

        //↓　無我夢中
        case 11:
            status =11;
            break;
        case 12:
            status =12;
            break;
    }
    return 1;
}

void drum(int num, bool on_off){
    if(on_off == true){
        timekeeper_1.start();
        solenoid[num] = true;
        led_pin[num%4] = 1;
    }else if (on_off == false){
        solenoid[num] = false;
        led_pin[num%4] = 0;
    }
}

void driveMotor(int num, double pwm){
    if (!pwm) {
        motor_pin[num][0] = 0;
        motor_pin[num][1] = 0;
        led_pin[num%4] = 0;
    } else if (0 < pwm) {
        motor_pin[num][0] = pwm;
        motor_pin[num][1] = 0;
        led_pin[num%4] = 1;
    } else {
        motor_pin[num][0] = 0;
        motor_pin[num][1] = -pwm;
        led_pin[num%4] = 1;
    }
}


    
void stop0(){/*
    if(timekeeper_1.read_ms()>100){
        stopt_0.attach_us(majistop1,100000);
    }
    if(d1.read_ms()>200) {*/
        driveMotor(0,0);
        led_pin[0] = 0;
    //}
}

void stop1(){
    drum(1,false);
    npx.off();
    led_pin[1] = 0;
}
void stop2(){
    drum(2,false);
    npx.off();
    led_pin[2] = 0;
}
void stop3(){
    drum(3,false);
    npx.off();
    led_pin[3] = 0;
}
void stop4(){
    drum(4,false);
    npx.off();
}
void stop5(){
    drum(5,false);
    npx.off();
}
void stop6(){
    drum(6,false);
    npx.off();
}
void stop7(){
    drum(7,false);
    npx.off();
}
void stop8(){
    drum(8,false);
    npx.off();
}
void stop9(){
    drum(9,false);
    npx.off();
}
void stop10(){
    drum(10,false);
    npx.off();
}
void stop11(){
    drum(11,false);
    npx.off();
}
void stop12(){
    drum(12,false);
}
void stop13(){
    drum(13,false);
}

void light_2(){
    if(solenoid[1] == true){
        tape_led[0] = true;
        light_drum_2();
    }
}

void light_2_1(){
    if(solenoid[2] == true){
        tape_led[0] = true;
        light_drum_2_1();
    }
}

void light_3(){
    if(solenoid[3] == true){
        tape_led[1] = true;
        light_drum_3();
    }
}

void light_4(){
    if(solenoid[4] == true){
        tape_led[2] = true;
        light_drum_4();
    }
}

void light_5(){
    if(solenoid[5] == true){
        tape_led[3] = true;
        light_drum_5();
    }
}

void light_5_1(){
    if(solenoid[6] == true){
        tape_led[3] = true;
        light_drum_5_1();
    }
}

void light_c_1(){
    if(solenoid[7] == true){
        tape_led[4] = true;
        light_cymbal_1();
    }
}

void light_c_1_1(){
    if(solenoid[8] == true){
        tape_led[4] = true;
        light_cymbal_1_1();
    }
}

void light_c_2(){
    if(solenoid[9] == true){
        tape_led[5] = true;
        light_cymbal_2();
    }
}

void light_c_3(){
    if(solenoid[10] == true){
        tape_led[6] = true;
        light_cymbal_3();
    }
}

void light_c_4(){
    if(solenoid[11] == true){
        tape_led[7] = true;
        light_cymbal_4();
    }
}

void play(note_t note){
    if(note.hit < 11){
        led_flag[note.hit] = true;
    }
    switch (note.hit){
        case drum_1:
            driveMotor(0,0.3);
            break;
        
        case drum_2:
            on_off = true;
            drum(note.hit,true);
            stop_1.attach_us(stop1,50000);
            break;
            
        
        case drum_2_1:
            on_off = true;
            drum(note.hit,true);
            stop_2.attach_us(stop2,50000);
            break;
        
        
        case drum_3:
            on_off = true;
            drum(note.hit,true);
            stop_3.attach_us(stop3,50000);
            break;
        
        case drum_4:
            on_off = true;
            drum(note.hit,true);
            stop_4.attach_us(stop4,50000);
            break;
        
        case drum_5:
            on_off = true;
            drum(note.hit,true);
            stop_5.attach_us(stop5,50000);
            break;
            
        case drum_5_1:
            on_off = true;
            drum(note.hit,true);
            stop_6.attach_us(stop6,50000);
            break;
        
        case cymbal_1:
            on_off = true;
            drum(note.hit,true);
            stop_7.attach_us(stop7,50000);
            break;
            
        case cymbal_1_1:
            on_off = true;
            drum(note.hit,true);
            stop_8.attach_us(stop8,50000);
            break;
        
        case cymbal_2:
            on_off = true;
            drum(note.hit,true);
            stop_9.attach_us(stop9,50000);
            break;
        
        case cymbal_3:
            on_off = true;
            drum(note.hit,true);
            stop_10.attach_us(stop10,50000);
            break;
        
        case cymbal_4:
            on_off = true;
            drum(note.hit,true);
            stop_11.attach_us(stop11,50000);
            break;
            
        case hihat_off:
            on_off = true;
            drum(note.hit,true);
            stop_12.attach_us(stop12,50000);
            break;
            
        case hihat_middle:
            on_off = true;
            drum(note.hit,true);
            stop_13.attach_us(stop13,50000);
            break;
            
        case rest:
            on_off = false;

        default:
            break;
    }
}

void limitswitch_stop(){
    drum_1_stop.attach_us(stop0,140000);
}
   

Timer timer;
Timer measure;

void druming(int numtime, const note_t* note, int num){
    static int i, j;
    static bool already;
    
    for (i = 0; i < numtime && status == prev_status; i++) {
        measure.reset();
        timer.reset();
        for (j = 0; j < num; j++) {
            
            while (note[j].time > timer.read_us()) {
                if(note[j].time - timer.read_us() > 0.3 && !already){
                    /*for(k = 1;k<12;k++){
                        if(led_flag[k]){
                            func[k]();
                            led_flag[k] = false;
                        }
                    }*/
                    npx.show();
                    already = true;
                }else if(note[j].time - timer.read_us() < 0.05 && already){
                    npx.off();
                    already = false;
                }
            }
            play(note[j]);
            timer.reset();
        }
        while(measure.read_us() < onemeasure);
    }
}

void druming2(int numtime, const note_t* note, int num){
    static int i, j;
    static bool already;

    for (i = 0; i < numtime && status == prev_status; i++) {
        measure.reset();
        timer.reset();
        for (j = 0; j < num; j++) {
            while (note[j].time > timer.read_us()) {
                if(note[j].time - timer.read_us() > 0.3 && !already){
                    npx.show();
                    already = true;
                }else if(note[j].time - timer.read_us() < 0.05 && already){
                    npx.off();
                    already = false;
                }
            }
            play(note[j]);
            timer.reset();
        }
        while(measure.read_us() < onemeasure_2);
    }
}

bool test(int rx_data,int &tx_data){
    drum(rx_data,true);
    wait(1);
    drum(rx_data,false);
    return true;
}

int main(){
    timekeeper_1.start();
    limit_switch.rise(limitswitch_stop);
    
    
    slave.addCMD(255, pause);
    slave.addCMD(2, command0);
    slave.addCMD(3, setup);
    slave.addCMD(4, test);
    
    npx.global_scale = 1.0f;
    npx.normalize = false;
    
    motor_pin[0][0].period_us(20);
    motor_pin[0][1].period_us(20);
    
    func[1] = light_2;
    func[2] = light_2_1;
    func[3] = light_3;
    func[4] = light_4;
    func[5] = light_5;
    func[6] = light_5_1;
    func[7] = light_c_1;
    func[8] = light_c_1_1;
    func[9] = light_c_2;
    func[10] = light_c_3;
    func[11] = light_c_4;

    timer.start();
    measure.start();
    while(1) {
        
        prev_status = status;
        switch (status) {
            case 0:
                break;
            case 1:
                checkpoint1();
                if(status == prev_status) {
                    status=2;
                }
                break;
            case 2:
                checkpoint2();
                if(status == prev_status) {
                    status=100;
                }
                break;
            //↓無我夢中
            case 11:
                checkpoint1_2();
                if(status == prev_status) {
                    status=38;
                }
                break;
                
            case 38:
                break;
                
            case 99:
                checkpoint();
                status=38;
                break;
        }
    }
}

void checkpoint(){
    druming(1,astro::mearsure,12);
}

void checkpoint1(){
    druming(3,astro::blank,4);
    druming(1,astro::mearsure_1,7);
    druming(1,astro::mearsure_2,17);
    druming(3,astro::mearsure_3,20);
    druming(1,astro::mearsure_4,11);
    druming(1,astro::mearsure_5,11);
    druming(1,astro::mearsure_6,17);
    druming(6,astro::mearsure_7,20);
    druming(1,astro::mearsure_8,20);
    druming(1,astro::mearsure_6,17);
    druming(1,astro::mearsure_9,17);
    druming(1,astro::mearsure_10,18);
    druming(1,astro::mearsure_9,17);
    druming(1,astro::mearsure_10,18);
    druming(1,astro::mearsure_9,17);
    druming(1,astro::mearsure_10,18);
    druming(1,astro::mearsure_11,14);
    druming(1,astro::mearsure_6,17);
    druming(2,astro::mearsure_7,20);
    druming(1,astro::mearsure_12,14);
    druming(2,astro::mearsure_13,12);
    druming(1,astro::mearsure_14,8);
    druming(1,astro::mearsure_15,13);
    druming(1,astro::mearsure_6,17);
    druming(1,astro::mearsure_16,21);
    druming(1,astro::mearsure_7,20);
    druming(1,astro::mearsure_16,21);
    druming(1,astro::mearsure_7,20);
    druming(1,astro::mearsure_16,21);
    druming(1,astro::mearsure_17,17);
    druming(1,astro::mearsure_18,21);
    druming(1,astro::mearsure_19,10);
    druming(1,astro::mearsure_20,11);
    druming(1,astro::mearsure_19,10);
    druming(3,astro::mearsure_20,11);
    druming(1,astro::mearsure_21,12);
    druming(1,astro::mearsure_22,12);
    druming(1,astro::mearsure_23,13);
    druming(1,astro::mearsure_24,7);
}//一番最後まで

void checkpoint2(){
    druming(1,astro::mearsure_6,17);
    druming(2,astro::mearsure_7,20);
    druming(1,astro::mearsure_8,20);
    druming(2,astro::mearsure_25,15);
    druming(1,astro::mearsure_26,10);
    druming(1,astro::mearsure_27,13);
    druming(1,astro::mearsure_10,18);
    druming(6,astro::mearsure_7,20);
    druming(1,astro::mearsure_28,15);
    druming(1,astro::mearsure_10,18);
    druming(1,astro::mearsure_16,21);
    druming(1,astro::mearsure_7,20);
    druming(1,astro::mearsure_16,21);
    druming(1,astro::mearsure_35,18);
    druming(1,astro::mearsure_29,9);
    druming(1,astro::mearsure_30,8);
    druming(1,astro::mearsure_31,11);
    druming(1,astro::mearsure_23,13);
    druming(1,astro::mearsure_39,5);
    druming(1,astro::mearsure_35,18);
    druming(1,astro::mearsure_36,11);
    druming(1,astro::mearsure_37,12);
    druming(1,astro::mearsure_38,8);
    druming(1,astro::mearsure_33,5);
    druming(1,astro::mearsure_34,6);
    druming(2,astro::blank,4);
}//天体観測終り

void checkpoint1_2(){
    druming(17,muga::blank_2,4);
    druming2(3,muga::mearsure_1_2,9);
    druming2(1,muga::mearsure_2_2,8);
    druming2(3,muga::mearsure_1_2,9);
    druming2(1,muga::mearsure_3_2,22);
    druming2(1,muga::mearsure_4_2,15);
    druming2(1,muga::mearsure_5_2,20);
    druming2(1,muga::mearsure_6_2,22);
    druming2(1,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_8_2,22);
    druming2(1,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_6_2,22);
    druming2(1,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_9_2,23);
    druming2(1,muga::mearsure_5_2,20);
    druming2(2,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_8_2,22);
    druming2(1,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_8_2,22);
    druming2(1,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_10_2,22);
    druming2(1,muga::mearsure_5_2,20);
    druming2(1,muga::mearsure_7_2,21);
    druming2(1,muga::mearsure_8_2,22);
    druming2(1,muga::mearsure_11_2,9);
    druming2(1,muga::mearsure_12_2,21);
    druming2(2,muga::mearsure_8_2,22);
    druming2(1,muga::mearsure_13_2,20);
    druming2(1,muga::mearsure_14_2,5);
    druming2(3,muga::blank_2,4);
    druming2(1,muga::mearsure_15_2,11);
    druming2(1,muga::mearsure_16_2,1);
    druming2(1,muga::mearsure_17_2,7);
    druming2(1,muga::mearsure_18_2,16);
    druming2(1,muga::mearsure_19_2,22);
    druming2(6,muga::mearsure_20_2,23);
    druming2(1,muga::mearsure_21_2,20);
    druming2(1,muga::mearsure_19_2,22);
    druming2(2,muga::mearsure_20_2,23);
    druming2(1,muga::mearsure_22_2,22);
}


/*ハイハット中間の時→hihat_middle
　ハイハットCLOSE→hihat_off
　左が半踏み真ん中が完全に閉まる

  左上⇒ハイハット//1,2
  左下⇒スネアドラム//3,4
  真ん中上⇒クラッシュ_low//1
  真ん中下⇒ハイタム//2・ロータム//3
  右上⇒ライドシンバル//1・クラッシュ_hight//2
  右下⇒フロアタム//3,4*/